/*
 * Decompiled with CFR 0.152.
 */
package com.vladmihalcea.flexypool.metric.micrometer;

import com.vladmihalcea.flexypool.common.ConfigurationProperties;
import com.vladmihalcea.flexypool.metric.AbstractMetrics;
import com.vladmihalcea.flexypool.metric.Histogram;
import com.vladmihalcea.flexypool.metric.Metrics;
import com.vladmihalcea.flexypool.metric.MetricsFactory;
import com.vladmihalcea.flexypool.metric.Timer;
import com.vladmihalcea.flexypool.metric.micrometer.MicrometerHistogram;
import com.vladmihalcea.flexypool.metric.micrometer.MicrometerTimer;
import io.micrometer.core.instrument.ImmutableTag;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.simple.SimpleMeterRegistry;
import java.util.Collections;
import java.util.List;

public class MicrometerMetrics
extends AbstractMetrics {
    private static final String POOLNAME_TAG = "poolname";
    public static final MetricsFactory FACTORY = new MetricsFactory(){

        public Metrics newInstance(ConfigurationProperties configurationProperties) {
            return new MicrometerMetrics(configurationProperties, (MeterRegistry)io.micrometer.core.instrument.Metrics.globalRegistry);
        }
    };
    private final MeterRegistry metricRegistry;

    public MicrometerMetrics(ConfigurationProperties configurationProperties, MeterRegistry metricRegistry) {
        super(configurationProperties);
        this.metricRegistry = metricRegistry;
    }

    public MicrometerMetrics(ConfigurationProperties configurationProperties) {
        this(configurationProperties, (MeterRegistry)new SimpleMeterRegistry());
    }

    public Histogram histogram(String name) {
        return new MicrometerHistogram(this.metricRegistry.summary(this.getConfigurationProperties().getMetricNamingStrategy().getMetricName(name), this.poolNameTag()));
    }

    public Timer timer(String name) {
        return new MicrometerTimer(this.metricRegistry.timer(this.getConfigurationProperties().getMetricNamingStrategy().getMetricName(name), this.poolNameTag()));
    }

    private List<Tag> poolNameTag() {
        return this.getConfigurationProperties().getMetricNamingStrategy().useUniquePoolName() ? Collections.singletonList(new ImmutableTag(POOLNAME_TAG, this.getConfigurationProperties().getUniqueName())) : Collections.emptyList();
    }

    public void start() {
    }

    public void stop() {
    }
}

