/*
 * Decompiled with CFR 0.152.
 */
package com.yammer.metrics.jdbi.strategies;

import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.jdbi.strategies.StatementName;
import com.yammer.metrics.jdbi.strategies.StatementNameStrategy;
import java.lang.reflect.Method;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.skife.jdbi.v2.ClasspathStatementLocator;
import org.skife.jdbi.v2.StatementContext;

public final class NameStrategies {
    public static final StatementNameStrategy CHECK_EMPTY = new CheckEmptyStrategy();
    public static final StatementNameStrategy CHECK_RAW = new CheckRawStrategy();
    public static final StatementNameStrategy SQL_OBJECT = new SqlObjectStrategy();
    public static final StatementNameStrategy NAIVE_NAME = new NaiveNameStrategy();
    public static final StatementNameStrategy CONTEXT_CLASS = new ContextClassStrategy();
    public static final StatementNameStrategy CONTEXT_NAME = new ContextNameStrategy();
    private static final MetricName EMPTY_SQL = new MetricName("sql", "empty", "");
    static final MetricName UNKNOWN_SQL = new MetricName("sql", "unknown", "");
    public static final String STATEMENT_CLASS = "_metric_class";
    public static final String STATEMENT_GROUP = "_metric_group";
    public static final String STATEMENT_TYPE = "_metric_type";
    public static final String STATEMENT_NAME = "_metric_name";

    private static MetricName forRawSql(String rawSql) {
        return StatementName.getJmxSafeName("sql", "raw", rawSql);
    }

    private NameStrategies() {
    }

    static final class ContextNameStrategy
    implements StatementNameStrategy {
        private static final Pattern SHORT_PATTERN = Pattern.compile("^(.*?)/(.*?)(-sql)?\\.st(g)?$");

        private ContextNameStrategy() {
        }

        @Override
        public MetricName getStatementName(StatementContext statementContext) {
            Object groupObj = statementContext.getAttribute(NameStrategies.STATEMENT_GROUP);
            Object typeObj = statementContext.getAttribute(NameStrategies.STATEMENT_TYPE);
            Object nameObj = statementContext.getAttribute(NameStrategies.STATEMENT_NAME);
            if (groupObj == null || nameObj == null) {
                return null;
            }
            String group = (String)groupObj;
            String statementName = (String)nameObj;
            if (typeObj == null) {
                Matcher matcher = SHORT_PATTERN.matcher(group);
                if (matcher.matches()) {
                    String groupName = matcher.group(1);
                    String typeName = matcher.group(2);
                    return StatementName.getJmxSafeName(groupName, typeName, statementName);
                }
                return StatementName.getJmxSafeName(group, statementName, "");
            }
            String type = (String)typeObj;
            return StatementName.getJmxSafeName(group, type, statementName);
        }
    }

    static final class ContextClassStrategy
    implements StatementNameStrategy {
        private ContextClassStrategy() {
        }

        @Override
        public MetricName getStatementName(StatementContext statementContext) {
            Object classObj = statementContext.getAttribute(NameStrategies.STATEMENT_CLASS);
            Object nameObj = statementContext.getAttribute(NameStrategies.STATEMENT_NAME);
            if (classObj == null || nameObj == null) {
                return null;
            }
            String className = (String)classObj;
            String statementName = (String)nameObj;
            int dotPos = className.lastIndexOf(46);
            if (dotPos == -1) {
                return null;
            }
            return StatementName.getJmxSafeName(className.substring(0, dotPos), className.substring(dotPos + 1), statementName);
        }
    }

    static final class SqlObjectStrategy
    implements StatementNameStrategy {
        private SqlObjectStrategy() {
        }

        @Override
        public MetricName getStatementName(StatementContext statementContext) {
            Class clazz = statementContext.getSqlObjectType();
            Method method = statementContext.getSqlObjectMethod();
            if (clazz != null) {
                String rawSql = statementContext.getRawSql();
                String group = clazz.getPackage().getName();
                String name = clazz.getSimpleName();
                String type = method == null ? rawSql : method.getName();
                return StatementName.getJmxSafeName(group, name, type);
            }
            return null;
        }
    }

    static final class NaiveNameStrategy
    implements StatementNameStrategy {
        private NaiveNameStrategy() {
        }

        @Override
        public MetricName getStatementName(StatementContext statementContext) {
            String rawSql = statementContext.getRawSql();
            int colon = rawSql.indexOf(58);
            if (colon == -1) {
                return NameStrategies.forRawSql(rawSql);
            }
            String group = rawSql.substring(0, colon);
            String name = rawSql.substring(colon + 1);
            return StatementName.getJmxSafeName(group, name, "");
        }
    }

    static final class CheckRawStrategy
    implements StatementNameStrategy {
        private CheckRawStrategy() {
        }

        @Override
        public MetricName getStatementName(StatementContext statementContext) {
            String rawSql = statementContext.getRawSql();
            if (ClasspathStatementLocator.looksLikeSql((String)rawSql)) {
                return NameStrategies.forRawSql(rawSql);
            }
            return null;
        }
    }

    static final class CheckEmptyStrategy
    implements StatementNameStrategy {
        private CheckEmptyStrategy() {
        }

        @Override
        public MetricName getStatementName(StatementContext statementContext) {
            String rawSql = statementContext.getRawSql();
            if (rawSql == null || rawSql.length() == 0) {
                return EMPTY_SQL;
            }
            return null;
        }
    }
}

