/*
 * Decompiled with CFR 0.152.
 */
package com.zaxxer.hikari.util;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public final class ClassLoaderUtils {
    public static ClassLoader getClassLoader() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader != null) {
            return new CascadingClassLoader(classLoader);
        }
        return ClassLoaderUtils.class.getClassLoader();
    }

    public static Class<?> loadClass(String string) throws ClassNotFoundException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader != null) {
            return new CascadingClassLoader(classLoader).loadClass(string);
        }
        return Class.forName(string);
    }

    public static Set<Class<?>> getAllInterfaces(Class<?> clazz) {
        HashSet hashSet = new HashSet();
        for (Class<?> clazz2 : Arrays.asList(clazz.getInterfaces())) {
            if (clazz2.getInterfaces().length > 0) {
                hashSet.addAll(ClassLoaderUtils.getAllInterfaces(clazz2));
            }
            hashSet.add(clazz2);
        }
        if (clazz.getSuperclass() != null) {
            hashSet.addAll(ClassLoaderUtils.getAllInterfaces(clazz.getSuperclass()));
        }
        if (clazz.isInterface()) {
            hashSet.add(clazz);
        }
        return hashSet;
    }

    private static class CascadingClassLoader
    extends ClassLoader {
        private ClassLoader contextLoader;

        CascadingClassLoader(ClassLoader classLoader) {
            this.contextLoader = classLoader;
        }

        @Override
        protected Class<?> findClass(String string) throws ClassNotFoundException {
            try {
                return this.contextLoader.loadClass(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                return CascadingClassLoader.class.getClassLoader().loadClass(string);
            }
        }
    }
}

