/*
 * Decompiled with CFR 0.152.
 */
package com.zaxxer.hikari.util;

import java.sql.Statement;

public final class FastStatementList {
    private Statement[] elementData;
    private int size;

    public FastStatementList() {
        this.elementData = new Statement[16];
    }

    public FastStatementList(int n) {
        this.elementData = new Statement[n];
    }

    public void add(Statement statement) {
        try {
            this.elementData[this.size++] = statement;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            int n = this.elementData.length;
            int n2 = n << 2;
            Statement[] statementArray = new Statement[n2];
            System.arraycopy(this.elementData, 0, statementArray, 0, n);
            statementArray[this.size++] = statement;
            this.elementData = statementArray;
        }
    }

    public Statement get(int n) {
        return this.elementData[n];
    }

    public void remove(Object object) {
        for (int i = this.size - 1; i >= 0; --i) {
            if (object != this.elementData[i]) continue;
            int n = this.size - i - 1;
            if (n > 0) {
                System.arraycopy(this.elementData, i + 1, this.elementData, i, n);
            }
            this.elementData[--this.size] = null;
            break;
        }
    }

    public void clear() {
        for (int i = 0; i < this.size; ++i) {
            this.elementData[i] = null;
        }
        this.size = 0;
    }

    public int size() {
        return this.size;
    }
}

