/*
 * Decompiled with CFR 0.152.
 */
package com.zaxxer.hikari.proxy;

import com.zaxxer.hikari.HikariPool;
import com.zaxxer.hikari.proxy.IHikariConnectionProxy;
import com.zaxxer.hikari.proxy.LeakTask;
import com.zaxxer.hikari.proxy.ProxyFactory;
import com.zaxxer.hikari.util.FastStatementList;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;

public abstract class ConnectionProxy
implements IHikariConnectionProxy {
    private static final Set<String> SQL_ERRORS = new HashSet<String>();
    protected final Connection delegate;
    private final FastStatementList openStatements;
    private final HikariPool parentPool;
    private final int defaultIsolationLevel;
    private boolean isClosed;
    private boolean forceClose;
    private boolean isTransactionIsolationDirty;
    private final long creationTime;
    private volatile long lastAccess;
    private StackTraceElement[] leakTrace;
    private TimerTask leakTask;

    protected ConnectionProxy(HikariPool pool, Connection connection, int defaultIsolationLevel) {
        this.parentPool = pool;
        this.delegate = connection;
        this.defaultIsolationLevel = defaultIsolationLevel;
        this.creationTime = this.lastAccess = System.currentTimeMillis();
        this.openStatements = new FastStatementList();
    }

    @Override
    public final void untrackStatement(Object statement) {
        if (!this.isClosed) {
            this.openStatements.remove(statement);
        }
    }

    @Override
    public final long getCreationTime() {
        return this.creationTime;
    }

    @Override
    public final long getLastAccess() {
        return this.lastAccess;
    }

    @Override
    public final void unclose() {
        this.isClosed = false;
    }

    @Override
    public final void realClose() throws SQLException {
        this.delegate.close();
    }

    @Override
    public final void captureStack(long leakDetectionThreshold, Timer scheduler) {
        StackTraceElement[] trace = Thread.currentThread().getStackTrace();
        this.leakTrace = new StackTraceElement[trace.length - 4];
        System.arraycopy(trace, 4, this.leakTrace, 0, this.leakTrace.length);
        this.leakTask = new LeakTask(this.leakTrace, leakDetectionThreshold);
        scheduler.schedule(this.leakTask, leakDetectionThreshold);
    }

    @Override
    public final boolean isTransactionIsolationDirty() {
        return this.isTransactionIsolationDirty;
    }

    @Override
    public void resetTransactionIsolationDirty() {
        this.isTransactionIsolationDirty = false;
    }

    @Override
    public final boolean isBrokenConnection() {
        return this.forceClose;
    }

    @Override
    public final void checkException(SQLException sqle) {
        String sqlState = sqle.getSQLState();
        if (sqlState != null) {
            this.forceClose |= sqlState.startsWith("08") | SQL_ERRORS.contains(sqlState);
        }
    }

    protected final void checkClosed() throws SQLException {
        if (this.isClosed) {
            throw new SQLException("Connection is closed");
        }
    }

    private final <T extends Statement> T trackStatement(T statement) {
        this.openStatements.add(statement);
        return statement;
    }

    @Override
    public void close() throws SQLException {
        if (!this.isClosed) {
            this.isClosed = true;
            if (this.leakTask != null) {
                this.leakTask.cancel();
                this.leakTask = null;
            }
            try {
                int size = this.openStatements.size();
                for (int i = 0; i < size; ++i) {
                    try {
                        this.openStatements.get(i).close();
                        continue;
                    }
                    catch (SQLException e) {
                        this.checkException(e);
                    }
                }
                if (!this.delegate.getAutoCommit()) {
                    this.delegate.rollback();
                }
            }
            catch (SQLException e) {
                this.checkException(e);
                throw e;
            }
            finally {
                this.openStatements.clear();
                this.lastAccess = System.currentTimeMillis();
                this.parentPool.releaseConnection(this);
            }
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    @Override
    public Statement createStatement() throws SQLException {
        this.checkClosed();
        try {
            Statement proxyStatement = ProxyFactory.getProxyStatement(this, this.delegate.createStatement());
            return this.trackStatement(proxyStatement);
        }
        catch (SQLException e) {
            this.checkException(e);
            throw e;
        }
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkClosed();
        try {
            Statement proxyStatement = ProxyFactory.getProxyStatement(this, this.delegate.createStatement(resultSetType, resultSetConcurrency));
            return this.trackStatement(proxyStatement);
        }
        catch (SQLException e) {
            this.checkException(e);
            throw e;
        }
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkClosed();
        try {
            Statement proxyStatement = ProxyFactory.getProxyStatement(this, this.delegate.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability));
            return this.trackStatement(proxyStatement);
        }
        catch (SQLException e) {
            this.checkException(e);
            throw e;
        }
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        this.checkClosed();
        try {
            CallableStatement proxyCallableStatement = ProxyFactory.getProxyCallableStatement(this, this.delegate.prepareCall(sql));
            return this.trackStatement(proxyCallableStatement);
        }
        catch (SQLException e) {
            this.checkException(e);
            throw e;
        }
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkClosed();
        try {
            CallableStatement proxyCallableStatement = ProxyFactory.getProxyCallableStatement(this, this.delegate.prepareCall(sql, resultSetType, resultSetConcurrency));
            return this.trackStatement(proxyCallableStatement);
        }
        catch (SQLException e) {
            this.checkException(e);
            throw e;
        }
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkClosed();
        try {
            CallableStatement proxyCallableStatement = ProxyFactory.getProxyCallableStatement(this, this.delegate.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability));
            return this.trackStatement(proxyCallableStatement);
        }
        catch (SQLException e) {
            this.checkException(e);
            throw e;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        this.checkClosed();
        try {
            PreparedStatement proxyPreparedStatement = ProxyFactory.getProxyPreparedStatement(this, this.delegate.prepareStatement(sql));
            return this.trackStatement(proxyPreparedStatement);
        }
        catch (SQLException e) {
            this.checkException(e);
            throw e;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        this.checkClosed();
        try {
            PreparedStatement proxyPreparedStatement = ProxyFactory.getProxyPreparedStatement(this, this.delegate.prepareStatement(sql, autoGeneratedKeys));
            return this.trackStatement(proxyPreparedStatement);
        }
        catch (SQLException e) {
            this.checkException(e);
            throw e;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkClosed();
        try {
            PreparedStatement proxyPreparedStatement = ProxyFactory.getProxyPreparedStatement(this, this.delegate.prepareStatement(sql, resultSetType, resultSetConcurrency));
            return this.trackStatement(proxyPreparedStatement);
        }
        catch (SQLException e) {
            this.checkException(e);
            throw e;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkClosed();
        try {
            PreparedStatement proxyPreparedStatement = ProxyFactory.getProxyPreparedStatement(this, this.delegate.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability));
            return this.trackStatement(proxyPreparedStatement);
        }
        catch (SQLException e) {
            this.checkException(e);
            throw e;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        this.checkClosed();
        try {
            PreparedStatement proxyPreparedStatement = ProxyFactory.getProxyPreparedStatement(this, this.delegate.prepareStatement(sql, columnIndexes));
            return this.trackStatement(proxyPreparedStatement);
        }
        catch (SQLException e) {
            this.checkException(e);
            throw e;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        this.checkClosed();
        try {
            PreparedStatement proxyPreparedStatement = ProxyFactory.getProxyPreparedStatement(this, this.delegate.prepareStatement(sql, columnNames));
            return this.trackStatement(proxyPreparedStatement);
        }
        catch (SQLException e) {
            this.checkException(e);
            throw e;
        }
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        if (this.isClosed) {
            return false;
        }
        try {
            return this.delegate.isValid(timeout);
        }
        catch (SQLException e) {
            this.checkException(e);
            throw e;
        }
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.checkClosed();
        try {
            this.delegate.setTransactionIsolation(level);
            this.isTransactionIsolationDirty = level != this.defaultIsolationLevel;
        }
        catch (SQLException e) {
            this.checkException(e);
            throw e;
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this.delegate);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isInstance(this.delegate)) {
            return (T)this.delegate;
        }
        throw new SQLException("Wrapped connection is not an instance of " + iface);
    }

    static {
        SQL_ERRORS.add("57P01");
        SQL_ERRORS.add("57P02");
        SQL_ERRORS.add("57P03");
        SQL_ERRORS.add("57P02");
        SQL_ERRORS.add("01002");
    }
}

