/*
 * Decompiled with CFR 0.152.
 */
package com.zaxxer.hikari;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariPool;
import com.zaxxer.hikari.proxy.IHikariConnectionProxy;
import com.zaxxer.hikari.util.DriverDataSource;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.HashMap;
import java.util.logging.Logger;
import javax.sql.DataSource;

public class HikariDataSource
extends HikariConfig
implements DataSource {
    private final HashMap<MultiPoolKey, HikariPool> multiPool;
    private volatile boolean isShutdown;
    private int loginTimeout;
    final HikariPool fastPathPool;
    volatile HikariPool pool;

    public HikariDataSource() {
        this.fastPathPool = null;
        this.multiPool = new HashMap();
    }

    public HikariDataSource(HikariConfig configuration) {
        configuration.validate();
        configuration.copyState(this);
        this.multiPool = new HashMap();
        this.pool = this.fastPathPool = new HikariPool(this);
        this.multiPool.put(new MultiPoolKey(this.getUsername(), this.getPassword()), this.pool);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Connection getConnection() throws SQLException {
        if (this.isShutdown) {
            throw new SQLException("Pool has been shutdown");
        }
        if (this.fastPathPool != null) {
            return this.fastPathPool.getConnection();
        }
        HikariPool result = this.pool;
        if (result == null) {
            HikariDataSource hikariDataSource = this;
            synchronized (hikariDataSource) {
                result = this.pool;
                if (result == null) {
                    this.validate();
                    this.pool = result = new HikariPool(this);
                    this.multiPool.put(new MultiPoolKey(this.getUsername(), this.getPassword()), this.pool);
                }
            }
        }
        return result.getConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        HikariPool hikariPool;
        if (this.isShutdown) {
            throw new SQLException("Pool has been shutdown");
        }
        MultiPoolKey key = new MultiPoolKey(username, password);
        HashMap<MultiPoolKey, HikariPool> hashMap = this.multiPool;
        synchronized (hashMap) {
            hikariPool = this.multiPool.get(key);
            if (hikariPool == null) {
                hikariPool = new HikariPool(this, username, password);
                this.multiPool.put(key, hikariPool);
            }
        }
        return hikariPool.getConnection();
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.pool.dataSource != null ? this.pool.dataSource.getLogWriter() : null;
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        if (this.pool.dataSource != null) {
            this.pool.dataSource.setLogWriter(out);
        }
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.loginTimeout = seconds;
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.loginTimeout;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (this.pool != null && iface.isInstance(this.pool.dataSource)) {
            return (T)this.pool.dataSource;
        }
        throw new SQLException("Wrapped connection is not an instance of " + iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.pool != null & this.pool.dataSource.getClass().isAssignableFrom(iface);
    }

    public void evictConnection(Connection connection) {
        if (!this.isShutdown && this.pool != null && connection instanceof IHikariConnectionProxy) {
            this.pool.closeConnection((IHikariConnectionProxy)connection);
        }
    }

    public void close() {
        this.shutdown();
    }

    public void shutdown() {
        if (this.isShutdown) {
            return;
        }
        this.isShutdown = true;
        if (this.pool != null) {
            this.pool.shutdown();
            if (this.pool.dataSource instanceof DriverDataSource) {
                ((DriverDataSource)this.pool.dataSource).shutdown();
            }
        }
        if (!this.multiPool.isEmpty()) {
            for (HikariPool hikariPool : this.multiPool.values()) {
                hikariPool.shutdown();
                if (!(hikariPool.dataSource instanceof DriverDataSource)) continue;
                ((DriverDataSource)hikariPool.dataSource).shutdown();
            }
        }
    }

    public String toString() {
        return String.format("HikariDataSource (%s)", this.pool);
    }

    private static class MultiPoolKey {
        private String username;
        private String password;

        MultiPoolKey(String username, String password) {
            this.username = username;
            this.password = password;
        }

        public int hashCode() {
            return this.password == null ? 0 : this.password.hashCode();
        }

        public boolean equals(Object obj) {
            MultiPoolKey otherKey = (MultiPoolKey)obj;
            if (this.username != null && !this.username.equals(otherKey.username)) {
                return false;
            }
            if (this.username != otherKey.username) {
                return false;
            }
            if (this.password != null && !this.password.equals(otherKey.password)) {
                return false;
            }
            return this.password == otherKey.password;
        }
    }
}

