/*
 * Decompiled with CFR 0.152.
 */
package cz.jirutka.validator.collection;

import cz.jirutka.validator.collection.constraints.EachConstraint;
import cz.jirutka.validator.collection.internal.AnnotationUtils;
import cz.jirutka.validator.collection.internal.ConstraintDescriptorFactory;
import cz.jirutka.validator.collection.internal.ConstraintValidatorContextUtils;
import cz.jirutka.validator.collection.internal.MessageInterpolatorContext;
import java.lang.annotation.Annotation;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.MessageInterpolator;
import javax.validation.Validation;
import javax.validation.ValidatorFactory;
import javax.validation.metadata.ConstraintDescriptor;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.reflect.TypeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonEachValidator
implements ConstraintValidator<Annotation, Collection<?>> {
    private static final Logger LOG = LoggerFactory.getLogger(CommonEachValidator.class);
    private static final ConstraintDescriptorFactory DESCRIPTOR_FACTORY = ConstraintDescriptorFactory.newInstance();
    @Inject
    private ValidatorFactory factory;
    private List<ConstraintDescriptor> descriptors;
    private Map<Class, Class<? extends ConstraintValidator<?, ?>>> validators;
    private Map<Class, ConstraintValidator> validatorInstances;
    private boolean earlyInterpolation = false;

    public void initialize(Annotation eachAnnotation) {
        Class<? extends Annotation> eachAType = eachAnnotation.annotationType();
        LOG.trace("Initializing CommonEachValidator for {}", eachAType);
        if (this.factory == null) {
            LOG.debug("No ValidatorFactory injected, building default one");
            this.factory = Validation.buildDefaultValidatorFactory();
        }
        this.validatorInstances = new ConcurrentHashMap<Class, ConstraintValidator>(2);
        if (eachAType.isAnnotationPresent(EachConstraint.class)) {
            Class<? extends Annotation> constraintClass = eachAType.getAnnotation(EachConstraint.class).validateAs();
            Annotation constraint = this.createConstraintAndCopyAttributes(constraintClass, eachAnnotation);
            ConstraintDescriptor descriptor = this.createConstraintDescriptor(constraint);
            this.descriptors = Collections.unmodifiableList(Arrays.asList(descriptor));
        } else if (this.isWrapperAnnotation(eachAType)) {
            Object[] constraints = this.unwrapConstraints(eachAnnotation);
            Validate.notEmpty((Object[])constraints, (String)"%s annotation does not contain any constraint", (Object[])new Object[]{eachAType});
            ArrayList<ConstraintDescriptor> list = new ArrayList<ConstraintDescriptor>(constraints.length);
            Object[] objectArray = constraints;
            int n = constraints.length;
            int n2 = 0;
            while (n2 < n) {
                Object constraint = objectArray[n2];
                list.add(this.createConstraintDescriptor((Annotation)constraint));
                ++n2;
            }
            this.descriptors = Collections.unmodifiableList(list);
            this.earlyInterpolation = true;
            LOG.info("You're using legacy @EachX annotation style, this will be removed soon! Please update your @EachX annotations.");
        } else {
            throw new IllegalArgumentException(String.format("%s is not annotated with @EachConstraint and doesn't declare 'value' of type Annotation[] either.", eachAType.getName()));
        }
        ConstraintDescriptor descriptor = this.descriptors.get(0);
        this.validators = this.categorizeValidatorsByType(descriptor.getConstraintValidatorClasses());
        Validate.notEmpty(this.validators, (String)"No validator found for constraint: %s", (Object[])new Object[]{descriptor.getAnnotation().annotationType()});
    }

    public boolean isValid(Collection<?> collection, ConstraintValidatorContext context) {
        if (collection == null || collection.isEmpty()) {
            return true;
        }
        context.disableDefaultConstraintViolation();
        int index = 0;
        for (Object element : collection) {
            ConstraintValidator validator = element != null ? this.getValidatorInstance(element.getClass()) : this.getAnyValidatorInstance();
            for (ConstraintDescriptor descriptor : this.descriptors) {
                validator.initialize(descriptor.getAnnotation());
                if (validator.isValid(element, context)) continue;
                LOG.debug("Element [{}] = '{}' is invalid according to: {}", new Object[]{index, element, validator.getClass().getName()});
                String message = this.earlyInterpolation ? this.createInterpolatedMessage(descriptor, element) : AnnotationUtils.readAttribute(descriptor.getAnnotation(), "message", String.class);
                ConstraintValidatorContextUtils.addConstraintViolationInIterable(context, message, index);
                return false;
            }
            ++index;
        }
        return true;
    }

    public void setValidatorFactory(ValidatorFactory factory) {
        this.factory = factory;
    }

    protected boolean isWrapperAnnotation(Class<? extends Annotation> annotationType) {
        return AnnotationUtils.hasAttribute(annotationType, "value") && Annotation[].class.isAssignableFrom(AnnotationUtils.getAttributeType(annotationType, "value"));
    }

    protected Annotation[] unwrapConstraints(Annotation wrapper) {
        return AnnotationUtils.readAttribute(wrapper, "value", Annotation[].class);
    }

    protected ConstraintDescriptor createConstraintDescriptor(Annotation constraint) {
        return DESCRIPTOR_FACTORY.buildConstraintDescriptor(constraint);
    }

    protected <T extends ConstraintValidator<?, ?>> Map<Class, Class<? extends T>> categorizeValidatorsByType(List<Class<? extends T>> validatorClasses) {
        LinkedHashMap validators = new LinkedHashMap(10);
        for (Class<T> validator : validatorClasses) {
            Class<?> type = this.determineTargetType(validator);
            if (type.isArray()) continue;
            LOG.trace("Found validator {} for type {}", (Object)validator.getName(), (Object)type.getName());
            validators.put(type, validator);
        }
        return Collections.unmodifiableMap(validators);
    }

    protected Class<?> determineTargetType(Class<? extends ConstraintValidator<?, ?>> validatorClass) {
        TypeVariable typeVar = ConstraintValidator.class.getTypeParameters()[1];
        return TypeUtils.getRawType(typeVar, validatorClass);
    }

    protected ConstraintValidator getValidatorInstance(Class<?> type) {
        ConstraintValidator validator = this.validatorInstances.get(type);
        if (validator == null) {
            validator = this.findAndInitializeValidator(type);
            this.validatorInstances.put(type, validator);
        }
        return validator;
    }

    protected ConstraintValidator getAnyValidatorInstance() {
        if (this.validatorInstances.isEmpty()) {
            Class type = this.validators.keySet().iterator().next();
            return this.findAndInitializeValidator(type);
        }
        return this.validatorInstances.values().iterator().next();
    }

    protected ConstraintValidator findAndInitializeValidator(Class<?> type) {
        LOG.trace("Looking for validator for type: {}", (Object)type.getName());
        for (Class clazz : this.validators.keySet()) {
            if (!clazz.isAssignableFrom(type)) continue;
            Class<ConstraintValidator<?, ?>> validatorClass = this.validators.get(clazz);
            LOG.trace("Initializing validator: {}", (Object)validatorClass.getName());
            return this.factory.getConstraintValidatorFactory().getInstance(validatorClass);
        }
        throw new IllegalArgumentException("No validator found for type: " + type.getName());
    }

    protected String createInterpolatedMessage(ConstraintDescriptor descriptor, Object value) {
        MessageInterpolatorContext context = new MessageInterpolatorContext(descriptor, value);
        Annotation constraint = descriptor.getAnnotation();
        String template = AnnotationUtils.readAttribute(constraint, "message", String.class);
        return this.factory.getMessageInterpolator().interpolate(template, (MessageInterpolator.Context)context);
    }

    protected <T extends Annotation> T createConstraintAndCopyAttributes(Class<T> constraintType, Annotation source) {
        Map<String, Object> attributes = AnnotationUtils.readAllAttributes(source);
        if (StringUtils.isEmpty((CharSequence)((String)attributes.get("message")))) {
            attributes.remove("message");
        }
        return AnnotationUtils.createAnnotation(constraintType, attributes);
    }
}

