/*
 * Decompiled with CFR 0.152.
 */
package cz.jirutka.validator.collection.internal;

import cz.jirutka.validator.collection.internal.HibernateValidatorInfo;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import javax.validation.metadata.ConstraintDescriptor;
import org.hibernate.validator.internal.metadata.core.ConstraintHelper;
import org.hibernate.validator.internal.metadata.core.ConstraintOrigin;
import org.hibernate.validator.internal.metadata.descriptor.ConstraintDescriptorImpl;

public abstract class ConstraintDescriptorFactory {
    private static final ConstraintHelper CONSTRAINT_HELPER = new ConstraintHelper();
    protected final Constructor<ConstraintDescriptorImpl> constructor;

    private ConstraintDescriptorFactory() {
        try {
            this.constructor = ConstraintDescriptorImpl.class.getConstructor(this.getConstructorArguments());
        }
        catch (NoSuchMethodException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public static ConstraintDescriptorFactory newInstance() {
        int version = HibernateValidatorInfo.getVersion();
        if (version >= 510) {
            return new ConstraintDescriptorFactory(){

                @Override
                Class[] getConstructorArguments() {
                    return new Class[]{ConstraintHelper.class, Member.class, Annotation.class, ElementType.class};
                }

                @Override
                ConstraintDescriptorImpl newInstance(Annotation annotation) throws ReflectiveOperationException {
                    return (ConstraintDescriptorImpl)this.constructor.newInstance(new Object[]{CONSTRAINT_HELPER, null, annotation, ElementType.LOCAL_VARIABLE});
                }
            };
        }
        if (version >= 500) {
            return new ConstraintDescriptorFactory(){

                @Override
                Class[] getConstructorArguments() {
                    return new Class[]{Annotation.class, ConstraintHelper.class, Class.class, ElementType.class, ConstraintOrigin.class, Member.class};
                }

                @Override
                ConstraintDescriptorImpl newInstance(Annotation annotation) throws ReflectiveOperationException {
                    return (ConstraintDescriptorImpl)this.constructor.newInstance(new Object[]{annotation, CONSTRAINT_HELPER, null, ElementType.LOCAL_VARIABLE, ConstraintOrigin.DEFINED_LOCALLY, null});
                }
            };
        }
        if (version >= 430) {
            return new ConstraintDescriptorFactory(){

                @Override
                Class[] getConstructorArguments() {
                    return new Class[]{Annotation.class, ConstraintHelper.class, Class.class, ElementType.class, ConstraintOrigin.class};
                }

                @Override
                ConstraintDescriptorImpl newInstance(Annotation annotation) throws ReflectiveOperationException {
                    return (ConstraintDescriptorImpl)this.constructor.newInstance(new Object[]{annotation, CONSTRAINT_HELPER, null, ElementType.LOCAL_VARIABLE, ConstraintOrigin.DEFINED_LOCALLY});
                }
            };
        }
        throw new UnsupportedVersionException("Hibernate Validator older then 4.3.0 is not supported");
    }

    public <T extends Annotation> ConstraintDescriptor<T> buildConstraintDescriptor(T annotation) {
        try {
            return this.newInstance(annotation);
        }
        catch (ReflectiveOperationException ex) {
            throw new IllegalStateException(ex);
        }
    }

    abstract ConstraintDescriptorImpl newInstance(Annotation var1) throws ReflectiveOperationException;

    abstract Class[] getConstructorArguments();

    /* synthetic */ ConstraintDescriptorFactory(ConstraintDescriptorFactory constraintDescriptorFactory) {
        this();
    }

    public static class UnsupportedVersionException
    extends IllegalStateException {
        public UnsupportedVersionException(String message) {
            super(message);
        }
    }
}

