/*
 * Decompiled with CFR 0.152.
 */
package de.danielbechler.diff;

import de.danielbechler.diff.CircularReferenceDetector;
import de.danielbechler.diff.DifferFactory;
import de.danielbechler.diff.Instances;
import de.danielbechler.diff.node.DefaultNode;
import de.danielbechler.diff.node.Node;
import de.danielbechler.util.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DifferDelegator {
    private static final Logger logger = LoggerFactory.getLogger(DifferDelegator.class);
    private static final ThreadLocal<CircularReferenceDetector> WORKING_CIRCULAR_REFERENCE_DETECTOR_THREAD_LOCAL = new CircularReferenceDetectorThreadLocal();
    private static final ThreadLocal<CircularReferenceDetector> BASE_CIRCULAR_REFERENCE_DETECTOR_THREAD_LOCAL = new CircularReferenceDetectorThreadLocal();
    private final DifferFactory differFactory;

    public DifferDelegator(DifferFactory differFactory) {
        this.differFactory = differFactory;
    }

    public Node delegate(Node parentNode, Instances instances) {
        Assert.notNull(instances, "instances");
        Class<?> type = instances.getType();
        if (type == null) {
            return DifferDelegator.newSimpleNode(parentNode, instances, type);
        }
        return this.delegateWithCircularReferenceTracking(parentNode, instances);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node delegateWithCircularReferenceTracking(Node parentNode, Instances instances) {
        Node node;
        try {
            DifferDelegator.rememberInstances(instances);
            try {
                node = this.compare(parentNode, instances);
            }
            finally {
                DifferDelegator.forgetInstances(instances);
            }
        }
        catch (CircularReferenceDetector.CircularReferenceException e) {
            node = DifferDelegator.newCircularNode(parentNode, instances);
            DifferDelegator.logCircularReference(node);
        }
        if (parentNode == null) {
            DifferDelegator.resetInstanceMemory();
        }
        return node;
    }

    private static Node newSimpleNode(Node parentNode, Instances instances, Class<?> type) {
        return new DefaultNode(parentNode, instances.getSourceAccessor(), type);
    }

    private static Node newCircularNode(Node parentNode, Instances instances) {
        DefaultNode node = new DefaultNode(parentNode, instances.getSourceAccessor(), instances.getType());
        node.setState(Node.State.CIRCULAR);
        return node;
    }

    private static void logCircularReference(Node node) {
        logger.warn("Detected circular reference in node at path {}. Going deeper would cause an infinite loop, so I'll stop looking at this instance along the current path.", (Object)node.getPropertyPath());
    }

    private Node compare(Node parentNode, Instances instances) {
        return this.differFactory.createDiffer(instances.getType(), this).compare(parentNode, instances);
    }

    private static void resetInstanceMemory() {
        WORKING_CIRCULAR_REFERENCE_DETECTOR_THREAD_LOCAL.remove();
        BASE_CIRCULAR_REFERENCE_DETECTOR_THREAD_LOCAL.remove();
    }

    private static void forgetInstances(Instances instances) {
        WORKING_CIRCULAR_REFERENCE_DETECTOR_THREAD_LOCAL.get().remove(instances.getWorking());
        BASE_CIRCULAR_REFERENCE_DETECTOR_THREAD_LOCAL.get().remove(instances.getBase());
    }

    private static void rememberInstances(Instances instances) {
        WORKING_CIRCULAR_REFERENCE_DETECTOR_THREAD_LOCAL.get().push(instances.getWorking());
        BASE_CIRCULAR_REFERENCE_DETECTOR_THREAD_LOCAL.get().push(instances.getBase());
    }

    private static final class CircularReferenceDetectorThreadLocal
    extends ThreadLocal<CircularReferenceDetector> {
        private CircularReferenceDetectorThreadLocal() {
        }

        @Override
        protected CircularReferenceDetector initialValue() {
            return new CircularReferenceDetector();
        }
    }
}

