/*
 * Decompiled with CFR 0.152.
 */
package de.dentrassi.asyncapi.generator.java;

import de.dentrassi.asyncapi.ArrayType;
import de.dentrassi.asyncapi.AsyncApi;
import de.dentrassi.asyncapi.CoreType;
import de.dentrassi.asyncapi.EnumType;
import de.dentrassi.asyncapi.Information;
import de.dentrassi.asyncapi.Message;
import de.dentrassi.asyncapi.MessageReference;
import de.dentrassi.asyncapi.ObjectType;
import de.dentrassi.asyncapi.ParentableType;
import de.dentrassi.asyncapi.Property;
import de.dentrassi.asyncapi.Topic;
import de.dentrassi.asyncapi.Type;
import de.dentrassi.asyncapi.TypeReference;
import de.dentrassi.asyncapi.generator.java.ConnectorType;
import de.dentrassi.asyncapi.generator.java.GeneratorExtension;
import de.dentrassi.asyncapi.generator.java.PackageTypeBuilder;
import de.dentrassi.asyncapi.generator.java.PropertyInformation;
import de.dentrassi.asyncapi.generator.java.ServiceDefinitions;
import de.dentrassi.asyncapi.generator.java.TopicInformation;
import de.dentrassi.asyncapi.generator.java.TypeBuilder;
import de.dentrassi.asyncapi.generator.java.TypeInformation;
import de.dentrassi.asyncapi.generator.java.util.JDTHelper;
import de.dentrassi.asyncapi.generator.java.util.Names;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.EnumConstantDeclaration;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.TagElement;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.TypeLiteral;
import org.eclipse.jdt.core.dom.TypeParameter;

public class Generator {
    private static final String TYPE_NAME_CONNECTOR = "de.dentrassi.asyncapi.Connector";
    private static final String TYPE_NAME_MESSAGE_INTERFACE = "de.dentrassi.asyncapi.Message";
    private static final String TYPE_NAME_PUBSUB_CLASS = "de.dentrassi.asyncapi.PublishSubscribe";
    private static final String TYPE_NAME_SUB_CLASS = "de.dentrassi.asyncapi.Subscribe";
    private static final String TYPE_NAME_PUB_CLASS = "de.dentrassi.asyncapi.Publish";
    private static final String TYPE_NAME_TOPIC_ANN = "de.dentrassi.asyncapi.Topic";
    private static final String TYPE_NAME_ABSTRACT_CONNECTOR_BUILDER = "de.dentrassi.asyncapi.Connector.AbstractBuilder";
    private final AsyncApi api;
    private final boolean validateTopicSyntax;
    private List<GeneratorExtension> extensions = new ArrayList<GeneratorExtension>();
    private final Options options;
    private final Context context = new Context(){

        @Override
        public TypeBuilder createTypeBuilder(String localPackageName) {
            return Generator.this.createTypeBuilder(new String[]{localPackageName});
        }

        @Override
        public String fullQualifiedName(String ... localName) {
            return Generator.this.packageName(localName);
        }

        @Override
        public ServiceDefinitions getServiceDefinitions() {
            return Generator.this.serviceDefinitions;
        }
    };
    private final ServiceDefinitions serviceDefinitions;

    public static Builder newBuilder() {
        return new Builder();
    }

    private Generator(AsyncApi api, Options options, boolean validateTopicSyntax, List<GeneratorExtension> extensions) {
        this.api = api;
        this.options = options;
        this.validateTopicSyntax = validateTopicSyntax;
        this.extensions = extensions;
        this.serviceDefinitions = ServiceDefinitions.build(this.api, this.validateTopicSyntax);
    }

    public void generate() throws IOException {
        Files.createDirectories(this.options.getTargetPath(), new FileAttribute[0]);
        this.generateRoot();
        this.generateMessages();
        this.generateTypes();
        this.generateTopics();
        for (GeneratorExtension extension : this.extensions) {
            extension.generate(this.api, this.options, this.context);
        }
    }

    private void generateTopics() {
        this.renderServices(ConnectorType.CLIENT);
        this.renderServices(ConnectorType.SERVER);
        this.renderConnector(ConnectorType.CLIENT);
        this.renderConnector(ConnectorType.SERVER);
    }

    private TypeBuilder createTypeBuilder(String ... localPackageName) {
        return new PackageTypeBuilder(this.options.getTargetPath(), this.packageName(localPackageName), this.options.getCharacterSet(), type -> null, this::lookupType);
    }

    private void renderConnector(ConnectorType connectorType) {
        TypeBuilder builder = this.createTypeBuilder(new String[0]);
        Consumer<TypeDeclaration> typeCustomizer = TypeBuilder.asInterface(true).andThen(TypeBuilder.superInterfaces(Arrays.asList(TYPE_NAME_CONNECTOR)));
        builder.createType(new TypeInformation(connectorType.getSimpleTypeName(), null, null), typeCustomizer, b -> {
            this.renderDefaultConnectorBuilder((TypeBuilder)b, connectorType);
            for (Map.Entry<String, Map<String, List<Topic>>> entry : this.serviceDefinitions.getVersions().entrySet()) {
                String version = Names.makeVersion(entry.getKey());
                b.createType(new TypeInformation(version.toUpperCase(), null, null), true, false, vb -> {
                    for (Map.Entry<String, List<Topic>> entry : ((Map)versionEntry.getValue()).entrySet()) {
                        TypeInformation serviceType = Generator.createServiceTypeInformation(entry);
                        vb.createMethod((ast, cu) -> {
                            MethodDeclaration md = ast.newMethodDeclaration();
                            md.setName(ast.newSimpleName(PackageTypeBuilder.asPropertyName(serviceType.getName())));
                            md.setReturnType2((org.eclipse.jdt.core.dom.Type)ast.newSimpleType(ast.newName(this.packageName(connectorType.getPackageName(), version, serviceType.getName()))));
                            return md;
                        });
                    }
                });
                b.createMethod((ast, cu) -> {
                    MethodDeclaration md = ast.newMethodDeclaration();
                    md.setName(ast.newSimpleName(version));
                    md.setReturnType2((org.eclipse.jdt.core.dom.Type)ast.newSimpleType((Name)ast.newSimpleName(version.toUpperCase())));
                    return md;
                });
            }
            for (Map.Entry<String, Object> entry : this.serviceDefinitions.getLatest().entrySet()) {
                b.createMethod((ast, cu) -> this.createReturnLatestVersionService((Map.Entry<String, ServiceDefinitions.VersionedService>)latestEntry, (AST)ast, connectorType));
            }
        });
    }

    private static ParameterizedType parametrizeSimple(org.eclipse.jdt.core.dom.Type original, String ... parameters) {
        AST ast = original.getAST();
        ParameterizedType result = ast.newParameterizedType(original);
        for (String name : parameters) {
            SimpleType type = ast.newSimpleType((Name)ast.newSimpleName(name));
            result.typeArguments().add(type);
        }
        return result;
    }

    private void renderDefaultConnectorBuilder(TypeBuilder builder, ConnectorType connectorType) {
        Consumer<TypeDeclaration> typeCustomizer = td -> {
            AST ast = td.getAST();
            SimpleType st = ast.newSimpleType(ast.newName(TYPE_NAME_ABSTRACT_CONNECTOR_BUILDER));
            td.setSuperclassType((org.eclipse.jdt.core.dom.Type)Generator.parametrizeSimple((org.eclipse.jdt.core.dom.Type)st, "B", "C"));
        };
        typeCustomizer = typeCustomizer.andThen(td -> {
            AST ast = td.getAST();
            TypeParameter b = ast.newTypeParameter();
            b.setName(ast.newSimpleName("B"));
            b.typeBounds().add(Generator.parametrizeSimple((org.eclipse.jdt.core.dom.Type)ast.newSimpleType((Name)ast.newSimpleName("Builder")), "B", "C"));
            TypeParameter c = ast.newTypeParameter();
            c.setName(ast.newSimpleName("C"));
            c.typeBounds().add(ast.newSimpleType((Name)ast.newSimpleName(connectorType.getSimpleTypeName())));
            td.typeParameters().add(b);
            td.typeParameters().add(c);
        });
        typeCustomizer = typeCustomizer.andThen(td -> JDTHelper.make((BodyDeclaration)td, Modifier.ModifierKeyword.STATIC_KEYWORD, Modifier.ModifierKeyword.ABSTRACT_KEYWORD));
        builder.createType(new TypeInformation("Builder", null, null), typeCustomizer, b -> b.createMethod((ast, cu) -> {
            MethodInvocation mi;
            MethodDeclaration md = ast.newMethodDeclaration();
            md.setConstructor(true);
            md.setName(ast.newSimpleName("Builder"));
            JDTHelper.makeProtected((BodyDeclaration)md);
            Block body = ast.newBlock();
            md.setBody(body);
            if (this.api.getHost() != null && !this.api.getHost().isEmpty()) {
                mi = ast.newMethodInvocation();
                mi.setName(ast.newSimpleName("host"));
                mi.arguments().add(JDTHelper.newStringLiteral(ast, this.api.getHost()));
                body.statements().add(ast.newExpressionStatement((Expression)mi));
            }
            if (this.api.getBaseTopic() != null && !this.api.getBaseTopic().isEmpty()) {
                mi = ast.newMethodInvocation();
                mi.setName(ast.newSimpleName("baseTopic"));
                mi.arguments().add(JDTHelper.newStringLiteral(ast, this.api.getBaseTopic()));
                body.statements().add(ast.newExpressionStatement((Expression)mi));
            }
            return md;
        }));
    }

    private MethodDeclaration createReturnLatestVersionService(Map.Entry<String, ServiceDefinitions.VersionedService> latestEntry, AST ast, ConnectorType connectorType) {
        String version = Names.makeVersion(latestEntry.getValue().getVersion().toString());
        String serviceType = this.packageName(connectorType.getPackageName(), version, latestEntry.getValue().getType().getName());
        MethodDeclaration md = ast.newMethodDeclaration();
        md.setName(ast.newSimpleName(PackageTypeBuilder.asPropertyName(latestEntry.getKey())));
        md.setReturnType2((org.eclipse.jdt.core.dom.Type)ast.newSimpleType(ast.newName(serviceType)));
        md.modifiers().add(ast.newModifier(Modifier.ModifierKeyword.DEFAULT_KEYWORD));
        Block block = ast.newBlock();
        md.setBody(block);
        ReturnStatement ret = ast.newReturnStatement();
        block.statements().add(ret);
        MethodInvocation versionMethod = ast.newMethodInvocation();
        versionMethod.setName(ast.newSimpleName(version.toLowerCase()));
        MethodInvocation serviceMethod = ast.newMethodInvocation();
        serviceMethod.setName(ast.newSimpleName(PackageTypeBuilder.asPropertyName(latestEntry.getKey())));
        serviceMethod.setExpression((Expression)versionMethod);
        ret.setExpression((Expression)serviceMethod);
        return md;
    }

    private void renderServices(ConnectorType connectorType) {
        for (Map.Entry<String, Map<String, List<Topic>>> versionEntry : this.serviceDefinitions.getVersions().entrySet()) {
            String packageName = connectorType.getPackageName();
            String version = Names.makeVersion(versionEntry.getKey());
            PackageTypeBuilder builder = new PackageTypeBuilder(this.options.getTargetPath(), this.packageName(packageName, version), this.options.getCharacterSet(), type -> null, this::lookupType);
            for (Map.Entry<String, List<Topic>> serviceEntry : versionEntry.getValue().entrySet()) {
                builder.createType(Generator.createServiceTypeInformation(serviceEntry), true, false, b -> {
                    for (Topic topic : (List)serviceEntry.getValue()) {
                        b.createMethod((ast, cu) -> {
                            TopicInformation ti = this.serviceDefinitions.getTopics().get(topic);
                            MethodDeclaration md = ast.newMethodDeclaration();
                            md.setName(ast.newSimpleName(Generator.makeTopicMethodName(ti)));
                            md.setReturnType2((org.eclipse.jdt.core.dom.Type)Generator.evalEventMethodType(ast, topic, this.context, connectorType));
                            NormalAnnotation an = ast.newNormalAnnotation();
                            an.setTypeName(ast.newName(TYPE_NAME_TOPIC_ANN));
                            an.values().add(Generator.newKeyValueString(ast, "name", topic.getName()));
                            if (topic.getPublish() != null) {
                                an.values().add(Generator.newKeyValueClass(ast, "publish", Generator.messageTypeName(topic.getPublish(), this.context)));
                            }
                            if (topic.getSubscribe() != null) {
                                an.values().add(Generator.newKeyValueClass(ast, "subscribe", Generator.messageTypeName(topic.getSubscribe(), this.context)));
                            }
                            md.modifiers().add(an);
                            JDTHelper.makePublic((BodyDeclaration)md);
                            return md;
                        });
                    }
                });
            }
        }
    }

    public static TypeInformation createServiceTypeInformation(Map.Entry<String, List<Topic>> serviceEntry) {
        return new TypeInformation(PackageTypeBuilder.asTypeName(serviceEntry.getKey()), null, null);
    }

    public static ParameterizedType evalEventMethodType(AST ast, Topic topic, Context context, ConnectorType connectorType) {
        MessageReference pubMsg = connectorType.getPublish(topic);
        MessageReference subMsg = connectorType.getSubscribe(topic);
        if (pubMsg == null && subMsg == null) {
            return null;
        }
        SimpleType eventType = pubMsg != null && subMsg != null ? ast.newSimpleType(ast.newName(TYPE_NAME_PUBSUB_CLASS)) : (pubMsg != null ? ast.newSimpleType(ast.newName(TYPE_NAME_PUB_CLASS)) : ast.newSimpleType(ast.newName(TYPE_NAME_SUB_CLASS)));
        ParameterizedType type = ast.newParameterizedType((org.eclipse.jdt.core.dom.Type)eventType);
        if (pubMsg != null) {
            type.typeArguments().add(ast.newSimpleType(ast.newName(Generator.messageTypeName(pubMsg, context))));
        }
        if (subMsg != null) {
            type.typeArguments().add(ast.newSimpleType(ast.newName(Generator.messageTypeName(subMsg, context))));
        }
        return type;
    }

    private static MemberValuePair newKeyValueClass(AST ast, String key, String typeName) {
        MemberValuePair pair = ast.newMemberValuePair();
        pair.setName(ast.newSimpleName(key));
        TypeLiteral type = ast.newTypeLiteral();
        type.setType((org.eclipse.jdt.core.dom.Type)ast.newSimpleType(ast.newName(typeName)));
        pair.setValue((Expression)type);
        return pair;
    }

    private static MemberValuePair newKeyValueString(AST ast, String key, String value) {
        MemberValuePair pair = ast.newMemberValuePair();
        pair.setName(ast.newSimpleName(key));
        StringLiteral topicLiteral = ast.newStringLiteral();
        topicLiteral.setLiteralValue(value);
        pair.setValue((Expression)topicLiteral);
        return pair;
    }

    public static String messageTypeName(MessageReference message, Context context) {
        return context.fullQualifiedName("messages") + "." + PackageTypeBuilder.asTypeName(message.getName());
    }

    public static String makeTopicMethodName(TopicInformation ti) {
        Stream<String> s = Stream.of(ti.getType());
        s = Stream.concat(s, ti.getResources().stream());
        s = Stream.concat(s, Stream.of(ti.getAction()));
        if (ti.getStatus().isPresent()) {
            s = Stream.concat(s, Stream.of(ti.getStatus().get().toString().toLowerCase()));
        }
        return Generator.joinLowerCamelCase(s);
    }

    private static String joinLowerCamelCase(Stream<String> s) {
        boolean first = true;
        StringBuilder sb = new StringBuilder();
        for (String tok : s::iterator) {
            int len = tok.length();
            if (len == 0) continue;
            Function<Character, Character> fn = first ? Character::toLowerCase : Character::toUpperCase;
            first = false;
            sb.append(fn.apply(Character.valueOf(tok.charAt(0))));
            sb.append(tok.substring(1).toLowerCase());
        }
        return sb.toString();
    }

    private void generateMessages() {
        PackageTypeBuilder builder = new PackageTypeBuilder(this.options.getTargetPath(), this.packageName("messages"), this.options.getCharacterSet(), this::resolveTypeName, this::lookupType);
        this.api.getMessages().forEach(message -> this.generateMessage(builder, (Message)message));
    }

    private Type lookupType(String typeName) {
        return this.api.getTypes().stream().filter(type -> type.getName().equals(typeName)).findFirst().orElseThrow(() -> new IllegalStateException(String.format("Unknown type '%s' referenced", typeName)));
    }

    private void generateMessage(TypeBuilder builder, Message message) {
        TypeInformation ti = new TypeInformation(PackageTypeBuilder.asTypeName(message.getName()), message.getSummary(), message.getDescription());
        Consumer<TypeDeclaration> typeCustomizer = td -> {
            AST ast = td.getAST();
            ParameterizedType type = ast.newParameterizedType((org.eclipse.jdt.core.dom.Type)ast.newSimpleType(ast.newName(TYPE_NAME_MESSAGE_INTERFACE)));
            type.typeArguments().add(ast.newSimpleType(ast.newName(ti.getName() + ".Payload")));
            td.superInterfaceTypes().add(type);
        };
        TypeReference payloadType = message.getPayload();
        builder.createType(ti, typeCustomizer, b -> {
            if (payloadType instanceof ObjectType) {
                this.generateType((TypeBuilder)b, (Type)payloadType);
                b.createProperty(new PropertyInformation((Type)payloadType, "payload", "Message payload", null));
            } else if (payloadType instanceof CoreType) {
                b.createProperty(new PropertyInformation((Type)((CoreType)message.getPayload()), "payload", "Message payload", null));
            } else if (payloadType.getClass().equals(TypeReference.class)) {
                b.createProperty(new PropertyInformation(this.lookupType(payloadType), "payload", "Message payload", null));
            } else {
                throw new IllegalStateException("Unsupported payload type: " + message.getPayload().getClass().getName());
            }
        });
    }

    private void generateTypes() {
        PackageTypeBuilder builder = new PackageTypeBuilder(this.options.getTargetPath(), this.packageName("types"), this.options.getCharacterSet(), this::resolveTypeName, this::lookupType);
        this.api.getTypes().forEach(type -> this.generateType(builder, (Type)type));
    }

    private void generateType(TypeBuilder builder, Type type) {
        if (type instanceof EnumType) {
            this.generateEnum((EnumType)type, builder);
        } else if (type instanceof ObjectType) {
            this.generateObject((ObjectType)type, builder);
        }
    }

    private void generateObject(ObjectType type, TypeBuilder builder) {
        TypeInformation ti = new TypeInformation(PackageTypeBuilder.asTypeName(type.getName()), type.getTitle(), type.getDescription());
        builder.createType(ti, false, true, b -> {
            for (Property property : type.getProperties()) {
                this.generateProperty(property, (TypeBuilder)b);
            }
        });
    }

    private static String toPrimitives(CoreType type) {
        String typeName;
        switch (typeName = type.getJavaType().getName()) {
            case "java.lang.Boolean": {
                return "boolean";
            }
            case "java.lang.Integer": {
                return "int";
            }
            case "java.lang.Long": {
                return "long";
            }
            case "java.lang.Float": {
                return "float";
            }
            case "java.lang.Short": {
                return "short";
            }
            case "java.lang.Byte": {
                return "byte";
            }
            case "java.lang.Character": {
                return "char";
            }
            case "java.lang.Double": {
                return "double";
            }
        }
        return typeName;
    }

    private String resolveTypeName(Type type) {
        return this.resolveTypeName((TypeReference)type, false);
    }

    private String resolveTypeName(TypeReference typeRef, boolean allowPrimitives) {
        if (typeRef instanceof ObjectType || typeRef instanceof EnumType) {
            return this.resolveParentableTypeName(typeRef);
        }
        if (typeRef instanceof CoreType) {
            if (allowPrimitives) {
                return Generator.toPrimitives((CoreType)typeRef);
            }
            return ((CoreType)typeRef).getJavaType().getName();
        }
        if (typeRef instanceof ArrayType) {
            return this.resolveTypeName(((ArrayType)typeRef).getItemType(), false);
        }
        return this.resolveTypeName((TypeReference)this.lookupType(typeRef.getName()), allowPrimitives);
    }

    private String resolveParentableTypeName(TypeReference typeRef) {
        LinkedList<String> full = new LinkedList<String>();
        full.add(typeRef.getNamespace());
        if (typeRef instanceof ParentableType) {
            for (String parent : ((ParentableType)typeRef).getParents()) {
                full.add(PackageTypeBuilder.asTypeName(parent));
            }
        }
        full.add(PackageTypeBuilder.asTypeName(typeRef.getName()));
        return this.packageName(String.join((CharSequence)".", full));
    }

    private Type lookupType(TypeReference typeRef) {
        if (typeRef instanceof Type) {
            return (Type)typeRef;
        }
        return this.lookupType(typeRef.getName());
    }

    private void generateProperty(Property property, TypeBuilder builder) {
        TypeReference type = property.getType();
        if (type instanceof Type) {
            this.generateType(builder, (Type)type);
        }
        String name = PackageTypeBuilder.asPropertyName(property.getName());
        String summary = property.getDescription();
        String description = null;
        builder.createProperty(new PropertyInformation(this.lookupType(type), name, summary, description));
    }

    private void generateEnum(EnumType type, TypeBuilder builder) {
        builder.createEnum(new TypeInformation(PackageTypeBuilder.asTypeName(type.getName()), type.getTitle(), type.getDescription()), type.getLiterals(), (literal, decl) -> this.fireExtensions(extension -> extension.createdEnumLiteral((String)literal, (EnumConstantDeclaration)decl)), true);
    }

    protected <T> void fireExtensions(Consumer<GeneratorExtension> consumer) {
        for (GeneratorExtension extension : this.extensions) {
            consumer.accept(extension);
        }
    }

    protected <T> void fireExtensions(T literal, BiConsumer<GeneratorExtension, T> consumer) {
        for (GeneratorExtension extension : this.extensions) {
            consumer.accept(extension, (GeneratorExtension)literal);
        }
    }

    private String packageName(String ... local) {
        Stream<CharSequence> full = this.options.getBasePackage() != null && !this.options.getBasePackage().isEmpty() ? Stream.of(this.options.getBasePackage()) : (this.api.getBaseTopic() != null && !this.api.getBaseTopic().isEmpty() ? Stream.of(this.api.getBaseTopic()) : Stream.empty());
        if (local != null) {
            full = Stream.concat(full, Arrays.stream(local));
        }
        return full.collect(Collectors.joining("."));
    }

    private void generateRoot() throws IOException {
        PackageTypeBuilder.createCompilationUnit(this.options.getTargetPath(), this.packageName(new String[0]), "package-info", this.options.getCharacterSet(), (ast, cu) -> {
            Information info = this.api.getInformation();
            Javadoc doc = ast.newJavadoc();
            if (info.getTitle() != null) {
                TagElement tag = ast.newTagElement();
                tag.fragments().add(JDTHelper.newText(ast, info.getTitle()));
                doc.tags().add(tag);
            }
            if (info.getVersion() != null) {
                TagElement version = ast.newTagElement();
                version.setTagName("@version");
                version.fragments().add(JDTHelper.newText(ast, info.getVersion()));
                doc.tags().add(version);
            }
            cu.getPackage().setJavadoc(doc);
        });
    }

    public static interface Context {
        public TypeBuilder createTypeBuilder(String var1);

        public String fullQualifiedName(String ... var1);

        public ServiceDefinitions getServiceDefinitions();
    }

    public static final class Builder {
        private final Options options = new Options();
        private boolean validateTopicSyntax = true;
        private final Set<GeneratorExtension> extensions = new HashSet<GeneratorExtension>();

        private Builder() {
        }

        public void addExtension(GeneratorExtension extension) {
            Objects.requireNonNull(extension);
            this.extensions.add(extension);
        }

        public Builder validateTopicSyntax(boolean validateTopicSyntax) {
            this.validateTopicSyntax = validateTopicSyntax;
            return this;
        }

        public Builder targetPath(Path targetPath) {
            Objects.requireNonNull(targetPath);
            this.options.targetPath = targetPath;
            return this;
        }

        public Builder basePackage(String basePackage) {
            this.options.basePackage = basePackage;
            return this;
        }

        public Builder characterSet(Charset characterSet) {
            this.options.characterSet = characterSet;
            return this;
        }

        public Generator build(AsyncApi api) {
            LinkedList errors = new LinkedList();
            this.options.validate(errors);
            if (!errors.isEmpty()) {
                RuntimeException e = new RuntimeException("Invalid generator settings", (Throwable)errors.pollFirst());
                errors.stream().forEach(e::addSuppressed);
                throw e;
            }
            return new Generator(api, new Options(this.options), this.validateTopicSyntax, new ArrayList<GeneratorExtension>(this.extensions));
        }
    }

    public static final class Options {
        private Path targetPath;
        private Charset characterSet = StandardCharsets.UTF_8;
        private String basePackage;

        private Options() {
        }

        private Options(Options other) {
            this.targetPath = other.targetPath;
            this.characterSet = other.characterSet;
            this.basePackage = other.basePackage;
        }

        public String getBasePackage() {
            return this.basePackage;
        }

        public Charset getCharacterSet() {
            return this.characterSet;
        }

        public Path getTargetPath() {
            return this.targetPath;
        }

        private void validate(List<Exception> errors) {
            if (this.targetPath == null) {
                errors.add(new IllegalStateException("'targetPath' is not set"));
            }
        }
    }
}

