/*
 * Decompiled with CFR 0.152.
 */
package de.dentrassi.asyncapi.generator.java;

import de.dentrassi.asyncapi.AsyncApi;
import de.dentrassi.asyncapi.Topic;
import de.dentrassi.asyncapi.generator.java.Generator;
import de.dentrassi.asyncapi.generator.java.TopicInformation;
import de.dentrassi.asyncapi.generator.java.TypeInformation;
import de.dentrassi.asyncapi.generator.java.util.Version;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class ServiceDefinitions {
    private final Map<Topic, TopicInformation> topics;
    private final Map<String, Map<String, List<Topic>>> versions;
    private final Map<String, VersionedService> latest;

    public ServiceDefinitions(Map<Topic, TopicInformation> topics, Map<String, Map<String, List<Topic>>> versions, Map<String, VersionedService> latest) {
        this.topics = Collections.unmodifiableMap(topics);
        this.versions = Collections.unmodifiableMap(versions);
        this.latest = Collections.unmodifiableMap(latest);
    }

    public Map<Topic, TopicInformation> getTopics() {
        return this.topics;
    }

    public Map<String, Map<String, List<Topic>>> getVersions() {
        return this.versions;
    }

    public Map<String, VersionedService> getLatest() {
        return this.latest;
    }

    public static ServiceDefinitions build(AsyncApi api, boolean validateTopicSyntax) {
        LinkedHashMap<Topic, TopicInformation> topics = new LinkedHashMap<Topic, TopicInformation>();
        HashMap<String, Map<String, List<Topic>>> versions = new HashMap<String, Map<String, List<Topic>>>();
        for (Topic topic : api.getTopics()) {
            TopicInformation ti;
            try {
                ti = TopicInformation.fromString(topic.getName());
            }
            catch (IllegalArgumentException e) {
                if (validateTopicSyntax) {
                    throw e;
                }
                ti = new TopicInformation("Topics", "1", "event", new LinkedList<String>(Arrays.asList(topic.getName().split("\\."))), "send", Optional.empty());
            }
            ServiceDefinitions.addTopic(versions, ti, topic);
            topics.put(topic, ti);
        }
        HashMap<String, VersionedService> latest = new HashMap<String, VersionedService>();
        for (Map.Entry versionEntry : versions.entrySet()) {
            for (Map.Entry<String, List<Topic>> entry : ((Map)versionEntry.getValue()).entrySet()) {
                TypeInformation serviceType = Generator.createServiceTypeInformation(entry);
                Version v = Version.valueOf((String)versionEntry.getKey());
                VersionedService lv = (VersionedService)latest.get(serviceType.getName());
                if (lv != null && v.compareTo(lv.getVersion()) <= 0) continue;
                latest.put(serviceType.getName(), new VersionedService(serviceType, v));
            }
        }
        return new ServiceDefinitions(topics, versions, latest);
    }

    private static void addTopic(Map<String, Map<String, List<Topic>>> versions, TopicInformation ti, Topic topic) {
        List<Topic> service;
        Map<String, List<Topic>> version = versions.get(ti.getVersion());
        if (version == null) {
            version = new HashMap<String, List<Topic>>();
            versions.put(ti.getVersion(), version);
        }
        if ((service = version.get(ti.getService())) == null) {
            service = new LinkedList<Topic>();
            version.put(ti.getService(), service);
        }
        service.add(topic);
    }

    public static class VersionedService {
        private final TypeInformation type;
        private final Version version;

        public VersionedService(TypeInformation type, Version version) {
            this.type = type;
            this.version = version;
        }

        public TypeInformation getType() {
            return this.type;
        }

        public Version getVersion() {
            return this.version;
        }
    }
}

