/*
 * Decompiled with CFR 0.152.
 */
package de.dentrassi.asyncapi.generator.java;

import de.dentrassi.asyncapi.generator.java.PropertyInformation;
import de.dentrassi.asyncapi.generator.java.TypeInformation;
import de.dentrassi.asyncapi.generator.java.util.JDTHelper;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.EnumConstantDeclaration;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.NumberLiteral;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;

public interface TypeBuilder {
    default public void createType(TypeInformation type, boolean iface, boolean serializable, Consumer<TypeBuilder> consumer) {
        this.createType(type, TypeBuilder.defaultTypeCustomizer(iface, serializable, true), consumer);
    }

    public void createType(TypeInformation var1, Consumer<TypeDeclaration> var2, Consumer<TypeBuilder> var3);

    public void createEnum(TypeInformation var1, Set<String> var2, BiConsumer<String, EnumConstantDeclaration> var3, boolean var4);

    public void createProperty(PropertyInformation var1);

    public void createBodyContent(BiFunction<AST, CompilationUnit, List<ASTNode>> var1);

    default public void createMethod(BiFunction<AST, CompilationUnit, MethodDeclaration> consumer) {
        this.createBodyContent((ast, cu) -> Collections.singletonList(consumer.apply((AST)ast, (CompilationUnit)cu)));
    }

    public static Consumer<TypeDeclaration> defaultTypeCustomizer(boolean iface, boolean serializable, boolean makeStatic) {
        Consumer<TypeDeclaration> typeCustomizer = TypeBuilder.asInterface(iface);
        typeCustomizer = typeCustomizer.andThen(TypeBuilder.superInterfaces(serializable ? Collections.singletonList("java.io.Serializable") : Collections.emptyList()));
        if (makeStatic) {
            typeCustomizer = typeCustomizer.andThen(JDTHelper::makeStatic);
        }
        if (serializable && !iface) {
            typeCustomizer = typeCustomizer.andThen(td -> {
                AST ast = td.getAST();
                PrimitiveType longType = ast.newPrimitiveType(PrimitiveType.LONG);
                NumberLiteral initializer = ast.newNumberLiteral();
                initializer.setToken("1L");
                FieldDeclaration sf = JDTHelper.createField(ast, (Type)longType, "serialVersionUID", (Expression)initializer, Modifier.ModifierKeyword.PRIVATE_KEYWORD, Modifier.ModifierKeyword.STATIC_KEYWORD, Modifier.ModifierKeyword.FINAL_KEYWORD);
                td.bodyDeclarations().add(sf);
            });
        }
        return typeCustomizer;
    }

    public static Consumer<TypeDeclaration> superInterfaces(List<String> types) {
        return td -> {
            AST ast = td.getAST();
            for (String name : types) {
                SimpleType type = ast.newSimpleType(ast.newName(name));
                td.superInterfaceTypes().add(type);
            }
        };
    }

    public static Consumer<TypeDeclaration> asInterface(boolean value) {
        return td -> td.setInterface(value);
    }

    public static Consumer<TypeDeclaration> superClass(String name) {
        return td -> {
            AST ast = td.getAST();
            SimpleType type = ast.newSimpleType(ast.newName(name));
            td.setSuperclassType((Type)type);
        };
    }

    public static Consumer<TypeDeclaration> make(Modifier.ModifierKeyword ... keywords) {
        return td -> {
            AST ast = td.getAST();
            for (Modifier.ModifierKeyword keyword : keywords) {
                td.modifiers().add(ast.newModifier(keyword));
            }
        };
    }
}

