/*
 * Decompiled with CFR 0.152.
 */
package de.dentrassi.asyncapi.generator.java.util;

import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclaration;

public final class Java {
    private Java() {
    }

    public static Stream<ASTNode> stream(List<?> nodes) {
        return nodes.stream();
    }

    public static <T extends ASTNode> Stream<ASTNode> stream(ASTNode node, Class<T> clazz, Function<T, List<?>> supplier) {
        return Java.stream(supplier.apply(clazz.cast(node)));
    }

    public static ASTNode firstBodyDeclaration(ASTNode node) {
        return Java.stream(node, TypeDeclaration.class, AbstractTypeDeclaration::bodyDeclarations).findFirst().get();
    }

    public static List<ASTNode> parse(AST ast, int kind, String code, Function<ASTNode, List<ASTNode>> extractor) {
        List result = Java.parseInternal(ast, kind, code, node -> {
            if (extractor != null) {
                return (List)extractor.apply((ASTNode)node);
            }
            return Collections.singletonList(node);
        });
        return ASTNode.copySubtrees((AST)ast, (List)result);
    }

    public static ASTNode parseSingle(AST ast, int kind, String code, Function<ASTNode, ASTNode> extractor) {
        ASTNode result = Java.parseInternal(ast, kind, code, node -> {
            if (extractor != null) {
                return (ASTNode)extractor.apply((ASTNode)node);
            }
            return node;
        });
        return ASTNode.copySubtree((AST)ast, (ASTNode)result);
    }

    public static List<ASTNode> parseSingleList(AST ast, int kind, String code, Function<ASTNode, ASTNode> extractor) {
        ASTNode result = Java.parseSingle(ast, kind, code, extractor);
        if (result == null) {
            throw new IllegalStateException("No element parsed");
        }
        return Collections.singletonList(result);
    }

    public static <T> T parseInternal(AST ast, int kind, String code, Function<ASTNode, T> extractor) {
        ASTParser parser = ASTParser.newParser((int)8);
        parser.setKind(kind);
        parser.setSource(code.toCharArray());
        ASTNode node = parser.createAST(null);
        return extractor.apply(node);
    }
}

