/*
 * Decompiled with CFR 0.152.
 */
package de.dentrassi.asyncapi.generator.java.util;

import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class Names {
    private Names() {
    }

    public static String toCamelCase(String text, boolean firstUpper) {
        return Names.toFormat(text, words -> Names.joinCamel(firstUpper, words));
    }

    public static String toLowerDash(String text) {
        return Names.toFormat(text, words -> Names.joinDelimiter(words, String::toLowerCase, "-"));
    }

    public static String toUpperUnderscore(String text) {
        return Names.toFormat(text, words -> Names.joinDelimiter(words, String::toUpperCase, "_"));
    }

    public static String toFormat(String text, Function<List<String>, String> target) {
        if (text == null) {
            return null;
        }
        LinkedList<String> words = new LinkedList<String>();
        int len = text.length();
        Type lastType = Type.UPPER;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            char c = text.charAt(i);
            Type type = Names.typeOf(c);
            if (lastType == Type.LOWER && (type == Type.UPPER || type == Type.NUMERIC)) {
                sb = Names.split(sb, words);
                sb = Names.append(sb, c);
            } else if (lastType == Type.NUMERIC && (type == Type.UPPER || type == Type.LOWER)) {
                sb = Names.split(sb, words);
                sb = Names.append(sb, c);
            } else {
                sb = type != Type.OTHER ? Names.append(sb, c) : Names.split(sb, words);
            }
            lastType = type;
        }
        Names.split(sb, words);
        return target.apply(words);
    }

    private static StringBuilder append(StringBuilder sb, char c) {
        if (sb == null) {
            sb = new StringBuilder();
        }
        sb.append(c);
        return sb;
    }

    private static StringBuilder split(StringBuilder sb, List<String> words) {
        if (sb != null) {
            words.add(sb.toString());
            sb = null;
        }
        return sb;
    }

    private static Type typeOf(char c) {
        if (Character.isUpperCase(c)) {
            return Type.UPPER;
        }
        if (Character.isDigit(c)) {
            return Type.NUMERIC;
        }
        if (Character.isAlphabetic(c)) {
            return Type.LOWER;
        }
        return Type.OTHER;
    }

    private static String joinDelimiter(List<String> words, Function<String, String> conversion, String delimiter) {
        if (conversion == null) {
            conversion = str -> str;
        }
        return words.stream().map(conversion).collect(Collectors.joining(delimiter));
    }

    private static String joinCamel(boolean firstUpper, List<String> words) {
        CharMapper mapper = firstUpper ? Character::toUpperCase : Character::toLowerCase;
        StringBuilder result = new StringBuilder();
        for (String word : words) {
            int wlen = word.length();
            if (wlen < 1) continue;
            result.append(mapper.map(word.charAt(0)));
            if (wlen > 1) {
                result.append(word.substring(1).toLowerCase());
            }
            mapper = Character::toUpperCase;
        }
        return result.toString();
    }

    public static String makeVersion(String version) {
        return "v" + version.replace(".", "_");
    }

    private static enum Type {
        UPPER,
        LOWER,
        NUMERIC,
        OTHER;

    }

    @FunctionalInterface
    private static interface CharConsumer {
        public void consume(char var1);
    }

    @FunctionalInterface
    private static interface CharMapper {
        public char map(char var1);
    }
}

