/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.process.extract;

import de.flapdoodle.embed.process.config.store.DownloadConfig;
import de.flapdoodle.embed.process.config.store.FileType;
import de.flapdoodle.embed.process.extract.CommonsArchiveEntryAdapter;
import de.flapdoodle.embed.process.extract.ExtractedFileSet;
import de.flapdoodle.embed.process.extract.ExtractionMatch;
import de.flapdoodle.embed.process.extract.Extractor;
import de.flapdoodle.embed.process.extract.FilesToExtract;
import de.flapdoodle.embed.process.extract.ImmutableExtractedFileSet;
import de.flapdoodle.embed.process.io.progress.ProgressListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractExtractor
implements Extractor {
    private static Logger _logger = LoggerFactory.getLogger(AbstractExtractor.class);

    protected abstract ArchiveWrapper archiveStream(File var1) throws IOException;

    private ArchiveWrapper archiveStreamWithExceptionHint(File source) throws IOException {
        try {
            return this.archiveStream(source);
        }
        catch (IOException iox) {
            _logger.warn("\n--------------------------\nIf you get this exception more than once, you should check if the file is corrupt.\nIf you remove the file ({}), it will be downloaded again.\n--------------------------", (Object)source.getAbsolutePath(), (Object)iox);
            throw new IOException("File " + source.getAbsolutePath(), iox);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExtractedFileSet extract(DownloadConfig runtime, File source, FilesToExtract toExtract) throws IOException {
        ImmutableExtractedFileSet.Builder builder = ExtractedFileSet.builder(toExtract.baseDir()).baseDirIsGenerated(toExtract.baseDirIsGenerated());
        ProgressListener progressListener = runtime.getProgressListener();
        String progressLabel = "Extract " + source;
        progressListener.start(progressLabel);
        try (ArchiveWrapper archive = this.archiveStreamWithExceptionHint(source);){
            ArchiveEntry entry;
            while ((entry = archive.getNextEntry()) != null) {
                ExtractionMatch match = toExtract.find(new CommonsArchiveEntryAdapter(entry));
                if (match == null) continue;
                if (archive.canReadEntryData(entry)) {
                    long size = entry.getSize();
                    FileType type = match.type();
                    File file = match.write(archive.asStream(entry), size);
                    if (type == FileType.Executable) {
                        builder.executable(file);
                    } else {
                        builder.addLibraryFiles(file);
                    }
                    progressListener.info(progressLabel, "extract " + entry.getName());
                }
                if (!toExtract.nothingLeft()) continue;
                progressListener.info(progressLabel, "nothing left");
                break;
            }
        }
        progressListener.done(progressLabel);
        return builder.build();
    }

    protected static interface ArchiveWrapper {
        public ArchiveEntry getNextEntry() throws IOException;

        public InputStream asStream(ArchiveEntry var1) throws IOException;

        public void close() throws IOException;

        public boolean canReadEntryData(ArchiveEntry var1);
    }
}

