/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.process.io;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class SuccessMessageLineListener {
    private final List<Pattern> successPatterns;
    private final List<Pattern> errorPatterns;
    private final String errorMessageGroupName;
    private boolean successMessageFound = false;
    private String errorMessage = null;
    private StringBuilder allLines = new StringBuilder();

    public SuccessMessageLineListener(List<Pattern> successPatterns, List<Pattern> errorPatterns, String errorMessageGroupName) {
        this.successPatterns = new ArrayList<Pattern>(successPatterns);
        this.errorPatterns = new ArrayList<Pattern>(errorPatterns);
        this.errorMessageGroupName = errorMessageGroupName;
    }

    public synchronized void inspect(String line) {
        boolean anyChange = false;
        if (!this.successMessageFound && this.errorMessage == null) {
            this.allLines.append(line).append("\n");
            for (Pattern successPattern : this.successPatterns) {
                if (!successPattern.matcher(line).find()) continue;
                this.successMessageFound = true;
                anyChange = true;
                break;
            }
            if (!this.successMessageFound) {
                for (Pattern errorPattern : this.errorPatterns) {
                    Matcher matcher = errorPattern.matcher(line);
                    if (!matcher.find()) continue;
                    this.errorMessage = matcher.group(this.errorMessageGroupName);
                    anyChange = true;
                }
            }
        }
        if (anyChange) {
            this.notify();
        }
    }

    public synchronized void waitForResult(long timeout) {
        try {
            this.wait(timeout);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public synchronized boolean successMessageFound() {
        return this.successMessageFound;
    }

    public synchronized Optional<String> errorMessage() {
        return Optional.ofNullable(this.errorMessage);
    }

    public synchronized String allLines() {
        return this.allLines.toString();
    }

    public static SuccessMessageLineListener of(String ... successPatterns) {
        return SuccessMessageLineListener.of(Arrays.asList(successPatterns), Collections.emptyList(), "");
    }

    public static SuccessMessageLineListener of(List<String> successPatterns, List<String> errorPatterns, String errorMessageGroupName) {
        return new SuccessMessageLineListener(successPatterns.stream().map(Pattern::compile).collect(Collectors.toList()), errorPatterns.stream().map(Pattern::compile).collect(Collectors.toList()), errorMessageGroupName);
    }
}

