/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.process.io.directories;

import de.flapdoodle.checks.Preconditions;
import de.flapdoodle.embed.process.io.directories.ImmutableTempDir;
import de.flapdoodle.embed.process.io.directories.Naming;
import de.flapdoodle.embed.process.types.Wrapper;
import de.flapdoodle.types.Try;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.function.Function;
import java.util.function.Supplier;
import org.immutables.value.Value;

@Value.Immutable
public abstract class TempDir
extends Wrapper<Path> {
    @Value.Auxiliary
    public Path createDirectory(String prefix, FileAttribute<?> ... attrs) throws IOException {
        return Files.createTempDirectory((Path)this.value(), prefix, attrs);
    }

    @Value.Auxiliary
    public Path createFile(String prefix, String suffix, FileAttribute<?> ... attrs) throws IOException {
        return Files.createTempFile((Path)this.value(), prefix, suffix, attrs);
    }

    public static TempDir of(Path path) {
        return ImmutableTempDir.of(path);
    }

    private static Path platform() {
        return Paths.get(System.getProperty("java.io.tmpdir"), new String[0]);
    }

    private static Path propertyOrPlatformTemp() {
        String custom = System.getProperty("de.flapdoodle.embed.io.tmpdir");
        return custom != null ? Paths.get(custom, new String[0]) : TempDir.platform();
    }

    private static Path createDirectoryIfNotExist(Path path) {
        Try.run(() -> {
            if (!Files.exists(path, new LinkOption[0])) {
                Files.createDirectory(path, new FileAttribute[0]);
            }
        });
        Preconditions.checkArgument((boolean)Files.isDirectory(path, new LinkOption[0]), (String)"%s is not a directory", (Object[])new Object[]{path});
        return path;
    }

    public static Supplier<TempDir> platformTempDir() {
        return () -> TempDir.of(TempDir.platform());
    }

    public static Supplier<TempDir> propertyOrPlatformTempDir() {
        return () -> TempDir.of(TempDir.propertyOrPlatformTemp());
    }

    public static Supplier<TempDir> platformTempSubDir(Naming naming) {
        return () -> TempDir.of(TempDir.createDirectoryIfNotExist(TempDir.platform().resolve(naming.nameFor("temp-", ""))));
    }

    public static Supplier<TempDir> propertyOrPlatformTempSubDir(Naming naming) {
        return () -> TempDir.of(TempDir.createDirectoryIfNotExist(TempDir.propertyOrPlatformTemp().resolve(naming.nameFor("temp-", ""))));
    }

    public static Function<TempDir, Path> createDirectoryWith(String prefix, FileAttribute<?> ... attrs) {
        return it -> (Path)Try.get(() -> it.createDirectory(prefix, attrs));
    }
}

