package de.flapdoodle.reflection;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ClassTypeInfo}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableClassTypeInfo.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableClassTypeInfo.of()}.
 */
@Generated(from = "ClassTypeInfo", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableClassTypeInfo<T> extends ClassTypeInfo<T> {
  private final Class<T> type;

  private ImmutableClassTypeInfo(Class<T> type) {
    this.type = Objects.requireNonNull(type, "type");
  }

  private ImmutableClassTypeInfo(ImmutableClassTypeInfo<T> original, Class<T> type) {
    this.type = type;
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @Override
  public Class<T> type() {
    return type;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ClassTypeInfo#type() type} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for type
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableClassTypeInfo<T> withType(Class<T> value) {
    if (this.type == value) return this;
    Class<T> newValue = Objects.requireNonNull(value, "type");
    return new ImmutableClassTypeInfo<>(this, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableClassTypeInfo} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableClassTypeInfo<?>
        && equalTo(0, (ImmutableClassTypeInfo<?>) another);
  }

  private boolean equalTo(int synthetic, ImmutableClassTypeInfo<?> another) {
    return type.equals(another.type);
  }

  /**
   * Computes a hash code from attributes: {@code type}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + type.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ClassTypeInfo} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ClassTypeInfo{"
        + "type=" + type
        + "}";
  }

  /**
   * Construct a new immutable {@code ClassTypeInfo} instance.
 * @param <T> generic parameter T
   * @param type The value for the {@code type} attribute
   * @return An immutable ClassTypeInfo instance
   */
  public static <T> ImmutableClassTypeInfo<T> of(Class<T> type) {
    return new ImmutableClassTypeInfo<>(type);
  }

  /**
   * Creates an immutable copy of a {@link ClassTypeInfo} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param <T> generic parameter T
   * @param instance The instance to copy
   * @return A copied immutable ClassTypeInfo instance
   */
  public static <T> ImmutableClassTypeInfo<T> copyOf(ClassTypeInfo<T> instance) {
    if (instance instanceof ImmutableClassTypeInfo<?>) {
      return (ImmutableClassTypeInfo<T>) instance;
    }
    return ImmutableClassTypeInfo.<T>builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableClassTypeInfo ImmutableClassTypeInfo}.
   * <pre>
   * ImmutableClassTypeInfo.&amp;lt;T&amp;gt;builder()
   *    .type(Class&amp;lt;T&amp;gt;) // required {@link ClassTypeInfo#type() type}
   *    .build();
   * </pre>
   * @param <T> generic parameter T
   * @return A new ImmutableClassTypeInfo builder
   */
  public static <T> ImmutableClassTypeInfo.Builder<T> builder() {
    return new ImmutableClassTypeInfo.Builder<>();
  }

  /**
   * Builds instances of type {@link ImmutableClassTypeInfo ImmutableClassTypeInfo}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ClassTypeInfo", generator = "Immutables")
  public static final class Builder<T> {
    private static final long INIT_BIT_TYPE = 0x1L;
    private long initBits = 0x1L;

    private Class<T> type;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ClassTypeInfo} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<T> from(ClassTypeInfo<T> instance) {
      Objects.requireNonNull(instance, "instance");
      this.type(instance.type());
      return this;
    }

    /**
     * Initializes the value for the {@link ClassTypeInfo#type() type} attribute.
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<T> type(Class<T> type) {
      this.type = Objects.requireNonNull(type, "type");
      initBits &= ~INIT_BIT_TYPE;
      return this;
    }

    /**
     * Builds a new {@link ImmutableClassTypeInfo ImmutableClassTypeInfo}.
     * @return An immutable instance of ClassTypeInfo
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableClassTypeInfo<T> build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableClassTypeInfo<>(null, type);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_TYPE) != 0) attributes.add("type");
      return "Cannot build ClassTypeInfo, some of required attributes are not set " + attributes;
    }
  }
}
