package de.flapdoodle.types;

import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Either.Right}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableRight.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableRight.of()}.
 */
@Generated(from = "Either.Right", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
final class ImmutableRight<L, R> extends Either.Right<L, R> {
  private final @Nullable R right;

  private ImmutableRight(@Nullable R right) {
    this.right = right;
  }

  /**
   * @return The value of the {@code right} attribute
   */
  @Override
  public @Nullable R right() {
    return right;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Either.Right#right() right} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for right (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRight<L, R> withRight(@Nullable R value) {
    if (this.right == value) return this;
    return new ImmutableRight<>(value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableRight} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableRight<?, ?>
        && equalTo(0, (ImmutableRight<?, ?>) another);
  }

  private boolean equalTo(int synthetic, ImmutableRight<?, ?> another) {
    return Objects.equals(right, another.right);
  }

  /**
   * Computes a hash code from attributes: {@code right}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(right);
    return h;
  }

  /**
   * Prints the immutable value {@code Right} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Right{"
        + "right=" + right
        + "}";
  }

  /**
   * Construct a new immutable {@code Right} instance.
 * @param <L> generic parameter L
 * @param <R> generic parameter R
   * @param right The value for the {@code right} attribute
   * @return An immutable Right instance
   */
  public static <L, R> ImmutableRight<L, R> of(@Nullable R right) {
    return new ImmutableRight<>(right);
  }

  /**
   * Creates an immutable copy of a {@link Either.Right} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param <L> generic parameter L
   * @param <R> generic parameter R
   * @param instance The instance to copy
   * @return A copied immutable Right instance
   */
  public static <L, R> ImmutableRight<L, R> copyOf(Either.Right<L, R> instance) {
    if (instance instanceof ImmutableRight<?, ?>) {
      return (ImmutableRight<L, R>) instance;
    }
    return ImmutableRight.<L, R>builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableRight ImmutableRight}.
   * <pre>
   * ImmutableRight.&amp;lt;L, R&amp;gt;builder()
   *    .right(R | null) // nullable {@link Either.Right#right() right}
   *    .build();
   * </pre>
   * @param <L> generic parameter L
   * @param <R> generic parameter R
   * @return A new ImmutableRight builder
   */
  public static <L, R> ImmutableRight.Builder<L, R> builder() {
    return new ImmutableRight.Builder<>();
  }

  /**
   * Builds instances of type {@link ImmutableRight ImmutableRight}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Either.Right", generator = "Immutables")
  public static final class Builder<L, R> {
    private R right;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Right} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<L, R> from(Either.Right<L, R> instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable R rightValue = instance.right();
      if (rightValue != null) {
        right(rightValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Either.Right#right() right} attribute.
     * @param right The value for right (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<L, R> right(@Nullable R right) {
      this.right = right;
      return this;
    }

    /**
     * Builds a new {@link ImmutableRight ImmutableRight}.
     * @return An immutable instance of Right
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableRight<L, R> build() {
      return new ImmutableRight<>(right);
    }
  }
}
