/*
 * Decompiled with CFR 0.152.
 */
package dev.equo.ide;

import dev.equo.ide.IdeHookInstantiated;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface IdeHook
extends Serializable {
    public IdeHookInstantiated instantiate() throws Exception;

    public static IdeHookInstantiated usingReflection(String implementationClassName, IdeHook constructorArg) throws Exception {
        Class<?> clazz = Class.forName(implementationClassName);
        Constructor<?> constructor = clazz.getDeclaredConstructor(constructorArg.getClass());
        return (IdeHookInstantiated)constructor.newInstance(constructorArg);
    }

    public static class InstantiatedList {
        private final ArrayList<IdeHookInstantiated> list = new ArrayList();
        private final Logger logger = LoggerFactory.getLogger(IdeHook.class);
        @Nullable
        private ArrayList<Map.Entry<Object, Exception>> errorsToReport = new ArrayList();
        @Nullable
        private BiConsumer<Object, Exception> errorLogger;

        private InstantiatedList() {
        }

        @Nullable
        <T extends IdeHookInstantiated> T find(Class<T> clazz) {
            for (IdeHookInstantiated e : this.list) {
                if (!clazz.isInstance(e)) continue;
                return (T)e;
            }
            return null;
        }

        void logError(Object hook, Exception e) {
            this.logger.error("IdeHook failure " + hook, (Throwable)e);
            if (this.errorLogger == null) {
                this.errorsToReport.add(Map.entry(hook, e));
            } else {
                this.errorLogger.accept(hook, e);
            }
        }

        void setErrorLogger(BiConsumer<Object, Exception> errorLogger) {
            if (this.errorLogger != null) {
                try {
                    throw new IllegalArgumentException("setErrorLogger was called twice!");
                }
                catch (IllegalArgumentException e) {
                    this.logger.warn(e.getMessage(), (Throwable)e);
                    return;
                }
            }
            this.errorLogger = errorLogger;
            for (Map.Entry<Object, Exception> entry : this.errorsToReport) {
                errorLogger.accept(entry.getKey(), entry.getValue());
            }
            this.errorsToReport = null;
        }

        void forEach(ThrowingConsumer method) {
            for (IdeHookInstantiated hook : this.list) {
                try {
                    method.accept(hook);
                }
                catch (Exception e) {
                    this.logError(hook, e);
                }
            }
        }

        <T> void forEach(ThrowingBiConsumer<T> method, T arg) {
            for (IdeHookInstantiated hook : this.list) {
                try {
                    method.accept(hook, arg);
                }
                catch (Exception e) {
                    this.logError(hook, e);
                }
            }
        }

        Iterator<IdeHookInstantiated> iterator() {
            return this.list.iterator();
        }

        static interface ThrowingBiConsumer<T> {
            public void accept(IdeHookInstantiated var1, T var2) throws Exception;
        }

        static interface ThrowingConsumer {
            public void accept(IdeHookInstantiated var1) throws Exception;
        }
    }

    public static class List
    extends ArrayList<IdeHook> {
        public List copy() {
            List copy = new List();
            copy.addAll(this);
            return copy;
        }

        InstantiatedList instantiate() {
            InstantiatedList list = new InstantiatedList();
            for (int i = 0; i < this.size(); ++i) {
                IdeHook hookGenerator = (IdeHook)this.get(i);
                try {
                    list.list.add(hookGenerator.instantiate());
                    continue;
                }
                catch (Exception e) {
                    list.logError(hookGenerator, e);
                }
            }
            return list;
        }
    }
}

