/*
 * Decompiled with CFR 0.152.
 */
package dev.equo.solstice.p2;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Optional;

public class CacheLocations {
    private static File ideWorkspaces = null;
    public static File override_ideWorkspaces = null;
    private static final String P2_DATA_WITHIN_M2 = "repository/dev/equo/p2-data/";
    private static final String P2_DATA_GRADLE_USER_HOME = "caches/p2-data";
    private static File p2data = null;
    public static File override_p2data = null;

    private CacheLocations() {
    }

    private static Optional<Path> userHome() {
        Path userHome = Path.of(System.getProperty("user.home"), new String[0]);
        if (userHome.isAbsolute() && Files.exists(userHome, new LinkOption[0])) {
            return Optional.of(userHome);
        }
        return Optional.empty();
    }

    public static File ideWorkspaces() {
        if (ideWorkspaces == null && (ideWorkspaces = override_ideWorkspaces) == null) {
            Optional<Path> userHome = CacheLocations.userHome();
            if (!userHome.isPresent()) {
                throw new IllegalStateException("Unable to determine user home: " + System.getProperty("user.home"));
            }
            ideWorkspaces = CacheLocations.userHome().get().resolve("ide-workspaces").toFile();
        }
        return ideWorkspaces;
    }

    public static File p2data() {
        if (p2data == null && (p2data = override_p2data) == null) {
            Optional<Path> userHome = CacheLocations.userHome();
            if (userHome.isPresent()) {
                p2data = userHome.get().resolve(".m2").resolve(P2_DATA_WITHIN_M2).toFile();
            } else {
                String gradleUserHome = System.getenv("GRADLE_USER_HOME");
                if (gradleUserHome != null) {
                    p2data = Path.of(gradleUserHome, new String[0]).resolve(P2_DATA_GRADLE_USER_HOME).toFile();
                } else {
                    throw new RuntimeException("Could not find user home or GRADLE_USER_HOME");
                }
            }
        }
        return p2data;
    }

    static File p2Queries() {
        return new File(CacheLocations.p2data(), "queries");
    }

    static File p2metadata() {
        return new File(CacheLocations.p2data(), "metadata");
    }

    static File p2bundlePool() {
        return new File(CacheLocations.p2data(), "bundle-pool");
    }

    public static File p2nestedJars() {
        return new File(CacheLocations.p2data(), "nested-jars");
    }

    public static File nestedJars() {
        return CacheLocations.p2nestedJars();
    }
}

