/*
 * Decompiled with CFR 0.152.
 */
package dev.snowdrop.boot.narayana.core.jdbc;

import dev.snowdrop.boot.narayana.core.jdbc.XAResourceConsumer;
import dev.snowdrop.boot.narayana.core.jdbc.XAResourceFunction;
import java.sql.SQLException;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import javax.transaction.xa.XAException;

public class ConnectionManager {
    private final XADataSource xaDataSource;
    private final String user;
    private final String password;
    private XAConnection xaConnection;

    public ConnectionManager(XADataSource xaDataSource, String user, String password) {
        this.xaDataSource = xaDataSource;
        this.user = user;
        this.password = password;
    }

    public void connectAndAccept(XAResourceConsumer consumer) throws XAException {
        if (this.isConnected()) {
            try {
                consumer.accept(this.xaConnection.getXAResource());
            }
            catch (SQLException ex) {
                throw this.createXAException(ex.getMessage());
            }
            return;
        }
        this.connect();
        try {
            consumer.accept(this.xaConnection.getXAResource());
        }
        catch (SQLException ex) {
            throw this.createXAException(ex.getMessage());
        }
        finally {
            this.disconnect();
        }
    }

    public <T> T connectAndApply(XAResourceFunction<T> function) throws XAException {
        if (this.isConnected()) {
            try {
                return function.apply(this.xaConnection.getXAResource());
            }
            catch (SQLException ex) {
                throw this.createXAException(ex.getMessage());
            }
        }
        this.connect();
        try {
            T ex = function.apply(this.xaConnection.getXAResource());
            return ex;
        }
        catch (SQLException ex) {
            throw this.createXAException(ex.getMessage());
        }
        finally {
            this.disconnect();
        }
    }

    public void connect() throws XAException {
        if (this.isConnected()) {
            return;
        }
        try {
            this.xaConnection = this.createXAConnection();
        }
        catch (SQLException ex) {
            if (this.xaConnection != null) {
                try {
                    this.xaConnection.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            throw this.createXAException(ex.getMessage());
        }
    }

    public void disconnect() {
        if (!this.isConnected()) {
            return;
        }
        try {
            this.xaConnection.close();
        }
        catch (SQLException sQLException) {
        }
        finally {
            this.xaConnection = null;
        }
    }

    public boolean isConnected() {
        return this.xaConnection != null;
    }

    private XAConnection createXAConnection() throws SQLException {
        if (this.user == null && this.password == null) {
            return this.xaDataSource.getXAConnection();
        }
        return this.xaDataSource.getXAConnection(this.user, this.password);
    }

    private XAException createXAException(String message) {
        XAException xaException = new XAException(message);
        xaException.errorCode = -7;
        return xaException;
    }
}

