/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.trustmanager;

import java.math.BigInteger;
import java.security.Principal;
import java.security.cert.CertPathValidatorException;
import java.security.cert.Certificate;
import java.security.cert.PKIXCertPathChecker;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLEntry;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import org.apache.log4j.Logger;

public class CRLCertChecker
extends PKIXCertPathChecker {
    private static final Logger LOGGER = Logger.getLogger((String)CRLCertChecker.class.getName());
    private Vector m_crls;
    private boolean m_crlRequired = false;

    public CRLCertChecker(Vector crls, boolean crlRequired) {
        this.m_crls = crls;
        this.m_crlRequired = crlRequired;
    }

    public void check(Certificate certificate, Collection collection) throws CertPathValidatorException {
        Iterator iter = this.m_crls.iterator();
        if (!(certificate instanceof X509Certificate)) {
            LOGGER.error((Object)"Error: non-X509 certificate given as an argument");
            throw new CertPathValidatorException("Error: non-X509 certificate given as an argument");
        }
        X509Certificate cert = (X509Certificate)certificate;
        Principal certIssuer = cert.getIssuerDN();
        BigInteger serial = cert.getSerialNumber();
        try {
            LOGGER.debug((Object)("Checking certificate " + cert.getSubjectDN().getName() + " with serial " + serial));
            while (iter.hasNext()) {
                X509CRL crl = (X509CRL)iter.next();
                if (!((Object)crl.getIssuerDN()).equals(certIssuer)) continue;
                LOGGER.debug((Object)("CRL found from " + certIssuer.getName()));
                X509CRLEntry crlEntry = crl.getRevokedCertificate(serial);
                if (crlEntry != null) {
                    LOGGER.info((Object)("The certificate is revoked by " + certIssuer.getName()));
                    throw new CertPathValidatorException("The certificate " + cert.getSubjectDN().getName() + " is revoked by " + certIssuer.getName());
                }
                LOGGER.debug((Object)"CRLCertChecker.check: certificate OK, cheked against CRL");
                return;
            }
            if (this.m_crlRequired) {
                LOGGER.warn((Object)("No crl (even though it is required) found for the CA " + ((Object)certIssuer).toString()));
                throw new CertPathValidatorException("No crl (even though it is required) found for the CA " + ((Object)certIssuer).toString());
            }
        }
        catch (Exception e) {
            LOGGER.debug((Object)("Certificate revocation checking failed: " + e.getMessage()));
            throw new CertPathValidatorException(e.getMessage());
        }
        LOGGER.debug((Object)"CRLCertChecker.check: certificate OK");
    }

    public Set getSupportedExtensions() {
        return null;
    }

    public void init(boolean param) throws CertPathValidatorException {
    }

    public boolean isForwardCheckingSupported() {
        return true;
    }

    public Vector getCrls() {
        return this.m_crls;
    }

    public void setCrls(Vector crls) {
        this.m_crls = crls;
    }
}

