/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.trustmanager;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.SignatureException;
import java.security.cert.CRLException;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.text.ParseException;
import java.util.Set;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.provider.X509CertificateObject;
import org.glite.security.trustmanager.CertPathValidatorState;
import org.glite.security.trustmanager.OpensslTrustmanager;
import org.glite.security.util.CaseInsensitiveProperties;
import org.glite.security.util.CertificateRevokedException;
import org.glite.security.util.DN;
import org.glite.security.util.DNHandler;
import org.glite.security.util.FullTrustAnchor;
import org.glite.security.util.TrustStorage;
import org.glite.security.util.namespace.DNCheckerImpl;
import org.glite.security.util.proxy.ProxyCertificateInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpensslCertPathValidator {
    private static final Logger LOGGER = Logger.getLogger((String)OpensslCertPathValidator.class.getName());
    private TrustStorage m_storage = null;
    private CertificateFactory m_certFact = CertificateFactory.getInstance("X.509", "BC");
    private boolean m_crlRequired = true;

    public OpensslCertPathValidator(String trustPath, boolean crlRequired) throws CertificateException, NoSuchProviderException, IOException, ParseException {
        this.m_storage = new TrustStorage(trustPath, null);
        this.m_crlRequired = crlRequired;
    }

    public OpensslCertPathValidator(String trustPath, boolean crlRequired, CaseInsensitiveProperties props) throws CertificateException, NoSuchProviderException, IOException, ParseException {
        this.m_storage = new TrustStorage(trustPath, props);
        this.m_crlRequired = crlRequired;
    }

    public boolean findAddParent(Vector<X509Certificate> inpath) {
        X509Certificate firstCert = inpath.lastElement();
        if (DNHandler.getSubject(firstCert).equals(DNHandler.getIssuer(firstCert))) {
            return false;
        }
        String hash = OpensslTrustmanager.getOpenSSLCAHash((X509Name)firstCert.getIssuerDN());
        FullTrustAnchor acceptedAnchor = null;
        FullTrustAnchor[] anchors = this.m_storage.getAnchors(hash);
        if (anchors != null) {
            LOGGER.debug((Object)("found " + anchors.length + " CAs that match, cheking which to use"));
            for (int n = 0; n < anchors.length; ++n) {
                if (!DNHandler.getSubject(anchors[n].m_caCert).equals(DNHandler.getIssuer(firstCert))) continue;
                acceptedAnchor = anchors[n];
                inpath.add(acceptedAnchor.m_caCert);
                return true;
            }
        }
        return false;
    }

    public Vector<X509Certificate> buildPath(X509Certificate[] inpath) throws CertPathValidatorException, CertificateException {
        Vector<X509Certificate> pathVect = new Vector<X509Certificate>();
        for (int i = 0; i < inpath.length; ++i) {
            if (inpath[i] instanceof X509CertificateObject) {
                pathVect.add(inpath[i]);
                continue;
            }
            byte[] bytes = inpath[i].getEncoded();
            BufferedInputStream certIS = new BufferedInputStream(new ByteArrayInputStream(bytes));
            pathVect.add((X509Certificate)this.m_certFact.generateCertificate(certIS));
        }
        X509Certificate caCert = (X509Certificate)pathVect.lastElement();
        boolean found = false;
        if (caCert.getBasicConstraints() > -1) {
            String hash = OpensslTrustmanager.getOpenSSLCAHash((X509Name)caCert.getSubjectDN());
            FullTrustAnchor acceptedAnchor = null;
            FullTrustAnchor[] anchors = this.m_storage.getAnchors(hash);
            if (anchors != null) {
                LOGGER.debug((Object)("found " + anchors.length + " CAs that match, cheking which to use"));
                for (int n = 0; n < anchors.length; ++n) {
                    if (!anchors[n].m_caCert.getPublicKey().equals(caCert.getPublicKey()) || !DNHandler.getSubject(anchors[n].m_caCert).equals(DNHandler.getSubject(caCert))) continue;
                    acceptedAnchor = anchors[n];
                    found = true;
                    pathVect.remove(caCert);
                    pathVect.add(acceptedAnchor.m_caCert);
                    break;
                }
            }
            if (!found && DNHandler.getSubject(caCert).equals(DNHandler.getIssuer(caCert))) {
                LOGGER.info((Object)("Self-signed CA cert " + DNHandler.getSubject(caCert) + " is not trusted, rejecting the certificate chain."));
                throw new CertPathValidatorException("Self-signed CA cert " + DNHandler.getSubject(caCert) + " is not trusted, rejecting the certificate chain.");
            }
        }
        if (!found && !(found = this.findAddParent(pathVect))) {
            LOGGER.info((Object)("The root of the cert chain " + DNHandler.getSubject(caCert) + " is not trusted CA nor issued by one, rejecting the certificate chain."));
            throw new CertPathValidatorException("The root of the cert chain " + DNHandler.getSubject(caCert) + " is not trusted CA nor issued by one, rejecting the certificate chain.");
        }
        while (found = this.findAddParent(pathVect)) {
        }
        return pathVect;
    }

    public void check(X509Certificate[] inpath) throws CertPathValidatorException, CertificateException {
        int currentIndex;
        if (inpath.length == 0) {
            LOGGER.error((Object)"No certificates given to check");
            throw new CertPathValidatorException("No certificates given to check");
        }
        if (LOGGER.isDebugEnabled()) {
            for (int i = 0; i < inpath.length; ++i) {
                LOGGER.debug((Object)("input path cert type: " + inpath[i].getClass().getName() + " DN [" + inpath[i].getSubjectDN() + "]"));
            }
        }
        Vector<X509Certificate> pathVect = this.buildPath(inpath);
        LOGGER.debug((Object)("Given path len is " + inpath.length + " and constructed path lenght " + pathVect.size()));
        CertPathValidatorState state = new CertPathValidatorState();
        state.m_proxyType = 71;
        X509Certificate[] certs = pathVect.toArray(new X509Certificate[0]);
        this.checkValidity(certs[currentIndex]);
        for (currentIndex = certs.length - 1; currentIndex > 0; --currentIndex) {
            X509Certificate current = certs[currentIndex];
            X509Certificate next = certs[currentIndex - 1];
            if (current.getBasicConstraints() > -1) {
                try {
                    state = this.checkAnchorAndCert(next, current, state, currentIndex == certs.length - 1);
                    continue;
                }
                catch (CRLException e) {
                    LOGGER.info((Object)("Certificate for " + DNHandler.getSubject(next) + " revoked by " + DNHandler.getSubject(current) + ", rejecting it"));
                    throw new CertPathValidatorException("Certificate for " + DNHandler.getSubject(next) + " revoked by " + DNHandler.getSubject(current) + ", rejecting it");
                }
                catch (Exception e) {
                    LOGGER.info((Object)("Certificate checking for " + DNHandler.getSubject(next) + " failed, rejecting it. Error was: " + e.getMessage()));
                    throw new CertPathValidatorException("Certificate checking for " + DNHandler.getSubject(next) + " failed, rejecting it. Error was: " + e.getMessage(), e);
                }
            }
            try {
                state = this.checkCertificatePair(next, current, state);
                continue;
            }
            catch (CertPathValidatorException e) {
                LOGGER.info((Object)e.getMessage());
                throw e;
            }
            catch (CertificateException e) {
                LOGGER.info((Object)e.getMessage());
                throw e;
            }
        }
        LOGGER.info((Object)("certificate path for " + DNHandler.getSubject(inpath[0]) + " is valid"));
    }

    public void checkValidity(X509Certificate cert) throws CertificateExpiredException, CertificateNotYetValidException {
        try {
            cert.checkValidity();
        }
        catch (CertificateExpiredException e) {
            LOGGER.info((Object)("the Certificate for " + DNHandler.getSubject(cert) + " expired on " + cert.getNotAfter()));
            throw new CertificateExpiredException("the Certificate for " + DNHandler.getSubject(cert) + " expired on " + cert.getNotAfter());
        }
        catch (CertificateNotYetValidException e) {
            LOGGER.info((Object)("the Certificate for " + DNHandler.getSubject(cert) + " will only be valid after " + cert.getNotBefore()));
            throw new CertificateNotYetValidException("the Certificate for " + DNHandler.getSubject(cert) + " will only be valid after " + cert.getNotBefore());
        }
    }

    public void checkSignature(X509Certificate sub, X509Certificate signer) throws CertPathValidatorException, CertificateException {
        LOGGER.debug((Object)"Checking the signature");
        PublicKey signKey = signer.getPublicKey();
        LOGGER.debug((Object)("Sub cert is " + sub.getClass().getName()));
        try {
            sub.verify(signKey);
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.info((Object)("Invalid signature algorithm in \"" + ((Object)sub.getSubjectDN()).toString() + "\" error was " + e.getClass().getName() + ":" + e.getMessage()));
            throw new CertificateException("Invalid signature algorithm in \"" + ((Object)sub.getSubjectDN()).toString() + "\" error was " + e.getClass().getName() + ":" + e.getMessage());
        }
        catch (InvalidKeyException e) {
            LOGGER.info((Object)("Invalid public key in \"" + ((Object)signer.getSubjectDN()).toString() + "\" error was " + e.getClass().getName() + ":" + e.getMessage()));
            throw new CertificateException("Invalid public key in \"" + ((Object)signer.getSubjectDN()).toString() + "\" error was " + e.getClass().getName() + ":" + e.getMessage());
        }
        catch (NoSuchProviderException e) {
            LOGGER.error((Object)("Internal error, no crypto provider found. Error was " + e.getClass().getName() + ":" + e.getMessage()));
            throw new CertificateException("Internal error, no crypto provider found. Error was " + e.getMessage());
        }
        catch (SignatureException e) {
            LOGGER.info((Object)("invalid signature in " + ((Object)sub.getSubjectDN()).toString()));
            throw new CertPathValidatorException("invalid signature in " + ((Object)sub.getSubjectDN()).toString());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CertPathValidatorState checkCertificatePair(X509Certificate sub, X509Certificate signer, CertPathValidatorState state) throws CertPathValidatorException, CertificateException {
        LOGGER.debug((Object)"Checking a cert pair");
        this.checkSignature(sub, signer);
        this.checkValidity(sub);
        CertPathValidatorState newState = new CertPathValidatorState();
        DN subIssuer = DNHandler.getIssuer(sub);
        DN signerSubject = DNHandler.getSubject(signer);
        DN subSubject = DNHandler.getSubject(sub);
        Set<String> criticalOIDs = sub.getCriticalExtensionOIDs();
        if (signerSubject.isEmpty() || subSubject.isEmpty()) {
            throw new CertPathValidatorException("Subject DN of " + (signerSubject.isEmpty() ? "parent" : "sub") + " certificate is empty, invalid certificate.");
        }
        LOGGER.debug((Object)"Checking cert basic constraints extension and proxy type");
        int signerPathLen = signer.getBasicConstraints();
        int subPathLen = sub.getBasicConstraints();
        if (signerPathLen >= 0) {
            if (subPathLen >= 0) {
                if (state.m_basicConstraintsPathLimit < 0) throw new CertPathValidatorException("Certificate " + subSubject + " has a CA flag, but path lenght is too long, it was limited by " + newState.m_basicConstraintsPathLimiter);
                if (subPathLen < state.m_basicConstraintsPathLimit) {
                    newState.m_basicConstraintsPathLimit = subPathLen - 1;
                    newState.m_basicConstraintsPathLimiter = subSubject;
                } else {
                    newState.m_basicConstraintsPathLimit = state.m_basicConstraintsPathLimit - 1;
                    newState.m_basicConstraintsPathLimiter = state.m_basicConstraintsPathLimiter;
                }
                newState.m_proxyType = 71;
            } else {
                newState.m_proxyType = 72;
            }
        } else {
            assert (state.m_proxyType == 71);
            if (subPathLen != -1) {
                throw new CertPathValidatorException("A certificate " + subSubject + " after non-CA cert " + signerSubject + " has a CA flag, which is not allowed. Rejecting certificate path.");
            }
            if (criticalOIDs != null) {
                if (criticalOIDs.contains("1.3.6.1.5.5.7.1.14")) {
                    criticalOIDs.remove("1.3.6.1.5.5.7.1.14");
                    newState.m_proxyType = 54;
                } else if (criticalOIDs.contains("1.3.6.1.4.1.3536.1.1.222")) {
                    criticalOIDs.remove("1.3.6.1.4.1.3536.1.1.222");
                    newState.m_proxyType = 53;
                } else {
                    if (!subSubject.getLastCNValue().toLowerCase().equals("proxy") && !subSubject.getLastCNValue().toLowerCase().equals("limited proxy")) throw new CertPathValidatorException("Unknown proxy type, no draft or RFC3820 extensions found and subject doesn't follow legacy proxy convention.");
                    newState.m_proxyType = 52;
                }
            } else {
                if (!subSubject.getLastCNValue().toLowerCase().equals("proxy") && !subSubject.getLastCNValue().toLowerCase().equals("limited proxy")) throw new CertPathValidatorException("Unknown proxy type, no draft or RFC3820 extensions found and subject doesn't follow legacy proxy convention.");
                newState.m_proxyType = 52;
            }
        }
        LOGGER.debug((Object)"Checking cert transitions.");
        if (state.m_proxyType == 71) {
            if (newState.m_proxyType != 71 && newState.m_proxyType != 72) {
                throw new CertPathValidatorException("The CA cert " + signerSubject + " can only sign sub CAs or user certs. The cert " + subSubject + " is neither.");
            }
        } else if (state.m_proxyType == 72) {
            if (newState.m_proxyType != 52 && newState.m_proxyType != 53 && newState.m_proxyType != 54) {
                throw new CertPathValidatorException("The end entity cert " + signerSubject + " can only sign proxies. The cert " + subSubject + " wasn't recognized as a proxy.");
            }
        } else {
            if (state.m_proxyType != 52 && state.m_proxyType != 53 && state.m_proxyType != 54) throw new CertPathValidatorException("Unknown cert " + signerSubject + " and transition");
            if (state.m_proxyType != newState.m_proxyType) {
                throw new CertPathValidatorException("The proxy cert " + signerSubject + " and the sub proxy cert " + subSubject + " are of different type.");
            }
        }
        if (newState.m_proxyType == 52 || newState.m_proxyType == 53 || newState.m_proxyType == 54) {
            boolean[] keyUsageBits;
            LOGGER.debug((Object)("Checkin that " + DNHandler.getSubject(signer) + " matches end of " + DNHandler.getSubject(sub) + " because proxy constraints"));
            this.checkDNRestriction(sub, signer, state.m_proxyType);
            if (newState.m_proxyType == 54 || newState.m_proxyType == 53) {
                int pathLimit;
                if (state.m_proxyInfoPathLimit < 0) {
                    throw new CertPathValidatorException("The proxy certificate path of \"" + subSubject + "\" is longer than allowed by \"" + state.m_proxyInfoPathLimiter + "\" that set the proxy path length limit.");
                }
                ProxyCertificateInfo info = new ProxyCertificateInfo(sub);
                try {
                    pathLimit = info.getProxyPathLimit();
                }
                catch (IOException e) {
                    throw new CertificateException("Parsing of a proxy certificate \"" + subSubject + "\" failed with: " + e.getMessage());
                }
                if (pathLimit < state.m_proxyInfoPathLimit) {
                    newState.m_proxyInfoPathLimit = pathLimit - 1;
                    newState.m_proxyInfoPathLimiter = subSubject;
                } else {
                    newState.m_proxyInfoPathLimit = state.m_proxyInfoPathLimit - 1;
                    newState.m_proxyInfoPathLimiter = state.m_proxyInfoPathLimiter;
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("ProxyInfoPath limit is: " + newState.m_proxyInfoPathLimit));
                }
            }
            if ((keyUsageBits = sub.getKeyUsage()) != null && !keyUsageBits[0]) {
                throw new CertPathValidatorException("The proxy cert " + subSubject + " has keyUsage extension, but the digital signature bit is not set as required.");
            }
        }
        if (criticalOIDs != null && !criticalOIDs.isEmpty()) {
            criticalOIDs.remove(X509Extensions.KeyUsage.toString());
        }
        if (criticalOIDs != null && !criticalOIDs.isEmpty()) {
            criticalOIDs.remove(X509Extensions.BasicConstraints.toString());
        }
        if (criticalOIDs != null && !criticalOIDs.isEmpty()) {
            throw new CertPathValidatorException("Certificate " + subSubject + " contains unsupported critical extensions, e.g. " + criticalOIDs.iterator().next());
        }
        LOGGER.debug((Object)"Checking DN match");
        if (!subIssuer.equals(signerSubject)) {
            throw new CertPathValidatorException("cert issuer DN (" + subIssuer + ") - Issuer subject DN (" + signerSubject + ") mismatch.");
        }
        if (signer.getBasicConstraints() <= -1) return newState;
        DNCheckerImpl checker = new DNCheckerImpl();
        FullTrustAnchor[] parentAnchors = state.m_anchorStack.toArray(new FullTrustAnchor[0]);
        for (int i = parentAnchors.length - 1; i >= 0; --i) {
            FullTrustAnchor anchor = parentAnchors[i];
            if (anchor.m_namespace == null || anchor.m_namespace.getPolices().isEmpty()) continue;
            checker.check(subSubject, signerSubject, anchor.m_namespace.getPolices());
            break;
        }
        newState.m_anchorStack = state.m_anchorStack;
        return newState;
    }

    public CertPathValidatorState checkAnchorAndCert(X509Certificate sub, X509Certificate caCert, CertPathValidatorState state, boolean firstAnchor) throws CertPathValidatorException, CertificateException, CRLException {
        LOGGER.debug((Object)"Checkin cert and anchor");
        String hash = OpensslTrustmanager.getOpenSSLCAHash((X509Name)caCert.getSubjectDN());
        FullTrustAnchor currentAnchor = null;
        FullTrustAnchor[] anchors = this.m_storage.getAnchors(hash);
        if (anchors != null) {
            LOGGER.debug((Object)("found " + anchors.length + " CAs that match, cheking which to use"));
            for (int n = 0; n < anchors.length; ++n) {
                if (!anchors[n].m_caCert.getPublicKey().equals(caCert.getPublicKey())) continue;
                currentAnchor = anchors[n];
            }
        }
        if (currentAnchor == null && firstAnchor) {
            throw new CertPathValidatorException("The CA certificate " + DNHandler.getSubject(caCert).getRFCDN() + " was not found. Certificate chain isn't based on any trusted CA.");
        }
        state.m_anchorStack.add(currentAnchor);
        CertPathValidatorState newstate = this.checkCertificatePair(sub, caCert, state);
        String caDN = DNHandler.getSubject(caCert).getRFCDN();
        String subDN = DNHandler.getSubject(sub).getRFCDN();
        if (currentAnchor == null) {
            if (this.m_crlRequired) {
                LOGGER.info((Object)("The certificate " + subDN + " is rejected as no CRL was found for CA " + caDN));
                throw new CertPathValidatorException("The certificate " + subDN + " is rejected as no CRL was found for CA " + caDN);
            }
        } else if (currentAnchor.m_revChecker != null) {
            try {
                currentAnchor.m_revChecker.check(sub);
            }
            catch (CertificateRevokedException e) {
                LOGGER.info((Object)("The certificate " + subDN + " is revoked by " + caDN + "."));
                throw new CertPathValidatorException("The certificate " + subDN + " revocation checking failed: " + e.getMessage());
            }
            catch (Exception e) {
                if (this.m_crlRequired) {
                    LOGGER.info((Object)("The certificate " + subDN + " revocation check failed! Problem was: " + e.getMessage()));
                    throw new CertPathValidatorException("The certificate " + subDN + " revocation check failed! Problem was: " + e.getMessage());
                }
                LOGGER.debug((Object)("The certificate " + subDN + " revocation check failed because CRL problem, but CRL checking was not required. Problem was: " + e.getMessage()));
            }
        } else {
            if (this.m_crlRequired) {
                LOGGER.info((Object)("The certificate " + subDN + " is not trusted as the revocation checker creation hasn't succeeded for the CA " + caDN + "."));
                throw new CertPathValidatorException("The certificate " + subDN + " is not trusted as the revocation cheker creation hasn't succeeded for the CA " + caDN + ".");
            }
            LOGGER.info((Object)("Revocation checker creation hasn't succeeded for CA " + caDN + ", but they're are not required, so accepting the cert " + subDN + "."));
        }
        if (currentAnchor != null && currentAnchor.m_caCert != null) {
            boolean[] keyUsageBits = currentAnchor.m_caCert.getKeyUsage();
            if (keyUsageBits != null && !keyUsageBits[5]) {
                throw new CertPathValidatorException("The CA cert " + caDN + " has keyUsage extension, but the keyCertSign bit is not set as required.");
            }
            int basicConstraints = currentAnchor.m_caCert.getBasicConstraints();
            if (basicConstraints < state.m_basicConstraintsPathLimit - 1) {
                newstate.m_basicConstraintsPathLimit = basicConstraints - 1;
                newstate.m_basicConstraintsPathLimiter = DNHandler.getSubject(currentAnchor.m_caCert);
            } else {
                newstate.m_basicConstraintsPathLimit = state.m_basicConstraintsPathLimit - 1;
                newstate.m_basicConstraintsPathLimiter = state.m_basicConstraintsPathLimiter;
            }
        } else {
            newstate.m_basicConstraintsPathLimit = state.m_basicConstraintsPathLimit;
            newstate.m_basicConstraintsPathLimiter = state.m_basicConstraintsPathLimiter;
        }
        LOGGER.debug((Object)("Certificate for " + subDN + " is validly issued by CA " + caDN));
        return newstate;
    }

    public X509Certificate[] getCACerts() {
        FullTrustAnchor[] anchors = this.m_storage.getAnchors();
        if (anchors == null) {
            return null;
        }
        X509Certificate[] certs = new X509Certificate[anchors.length];
        for (int n = 0; n < anchors.length; ++n) {
            certs[n] = anchors[n].m_caCert;
        }
        LOGGER.debug((Object)("getCACerts: returning " + certs.length + " ca certs"));
        return certs;
    }

    public void checkDNRestriction(X509Certificate sub, X509Certificate signer, int proxyType) throws CertificateException {
        LOGGER.debug((Object)"Checking dn restriction");
        DN subDN = DNHandler.getSubject(sub);
        DN signerDN = DNHandler.getSubject(signer);
        try {
            String lastCN;
            DN subDNWithoutProxy = subDN.withoutLastCN(false);
            if (!subDNWithoutProxy.equals(signerDN)) {
                throw new CertificateException("The DN [" + subDN + "] doesn't end with [" + signerDN + "] as required for proxy certs");
            }
            if (proxyType == 52 && !(lastCN = subDN.getLastCNValue().toLowerCase()).matches("limited proxy|proxy")) {
                throw new CertPathValidatorException("Legacy proxy " + subDN.getCanon() + " does not end with \"proxy\" or \"limited proxy\" as required.");
            }
        }
        catch (Exception e) {
            LOGGER.info((Object)("Error while cheking naming constrainst between sub [" + subDN + "] and signer [" + signerDN + " error: " + e + e.getMessage()));
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"StacTrace: ", (Throwable)e);
            }
            if (e instanceof CertificateException) {
                throw (CertificateException)e;
            }
            throw new CertificateException("Error while cheking naming constrainst between sub [" + subDN + "] and signer [" + signerDN + "] error: " + e + e.getMessage());
        }
    }

    public void checkUpdate() throws IOException, CertificateException, ParseException {
        if (this.m_storage != null) {
            this.m_storage.checkUpdate();
        }
    }

    static {
        if (Security.getProvider("BC") == null) {
            LOGGER.debug((Object)"ContextWrapper: bouncycastle provider set.");
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }
}

