/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.trustmanager;

import java.io.IOException;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.text.ParseException;
import javax.net.ssl.X509TrustManager;
import org.apache.log4j.Logger;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.crypto.digests.MD5Digest;
import org.glite.security.trustmanager.OpensslCertPathValidator;
import org.glite.security.util.CaseInsensitiveProperties;

public class OpensslTrustmanager
implements X509TrustManager {
    private static final Logger LOGGER = Logger.getLogger(OpensslTrustmanager.class);
    private OpensslCertPathValidator m_validator = null;

    public OpensslTrustmanager(String dir, boolean crlRequired) throws IOException, CertificateException, ParseException, NoSuchProviderException {
        this.m_validator = new OpensslCertPathValidator(dir, crlRequired, null);
    }

    public OpensslTrustmanager(String dir, boolean crlRequired, CaseInsensitiveProperties props) throws IOException, CertificateException, ParseException, NoSuchProviderException {
        this.m_validator = new OpensslCertPathValidator(dir, crlRequired, props);
    }

    public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
        LOGGER.debug((Object)("CheckClientTrusted cert=" + arg0 + " string= " + arg1));
        try {
            this.m_validator.check(arg0);
        }
        catch (Exception e) {
            LOGGER.info((Object)("The certificate validation for [" + arg0[0].getSubjectDN() + "] failed: " + e.getMessage()));
            throw new CertificateException(e.getMessage());
        }
    }

    public void checkServerTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
        LOGGER.debug((Object)("CheckServerTrusted cert=" + arg0 + " string= " + arg1));
        try {
            this.checkClientTrusted(arg0, arg1);
        }
        catch (CertificateException e) {
            LOGGER.error((Object)("The certificate validation for [" + arg0[0].getSubjectDN() + "] failed: " + e.getMessage()));
            throw e;
        }
    }

    public X509Certificate[] getAcceptedIssuers() {
        LOGGER.debug((Object)"getAcceptedIssuers");
        if (this.m_validator != null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"getAcceptedIssuers returning:");
                X509Certificate[] certs = this.m_validator.getCACerts();
                for (int i = 0; i < certs.length; ++i) {
                    LOGGER.debug((Object)(i + ": " + certs[i].getSubjectDN()));
                }
            }
            return this.m_validator.getCACerts();
        }
        return null;
    }

    public static String getOpenSSLCAHash(X509Name subject) {
        byte[] bytes = subject.getDEREncoded();
        MD5Digest digest = new MD5Digest();
        digest.update(bytes, 0, bytes.length);
        byte[] output = new byte[16];
        digest.doFinal(output, 0);
        StringBuffer outputString = new StringBuffer();
        outputString.append(String.format("%02x", output[3] & 0xFF));
        outputString.append(String.format("%02x", output[2] & 0xFF));
        outputString.append(String.format("%02x", output[1] & 0xFF));
        outputString.append(String.format("%02x", output[0] & 0xFF));
        return outputString.toString();
    }

    public void checkUpdate() throws IOException, CertificateException, ParseException {
        if (this.m_validator != null) {
            this.m_validator.checkUpdate();
        }
    }

    public static String getOpenSSLCAHash(X509Certificate cert) {
        X509Name subject = (X509Name)cert.getSubjectDN();
        return OpensslTrustmanager.getOpenSSLCAHash(subject);
    }
}

