/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.util;

import java.security.Principal;
import java.util.Hashtable;
import javax.security.auth.x500.X500Principal;
import org.apache.log4j.Logger;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.jce.X509Principal;
import org.glite.security.util.DN;
import org.glite.security.util.DNHandler;
import org.glite.security.util.DNImpl;

public class DNImplRFC2253
implements DN {
    public static final int RFC2253 = 0;
    public static final int X500 = 1;
    public static final int CANON = 2;
    private static final Logger LOGGER = Logger.getLogger(DNImplRFC2253.class);
    public String m_rfc2253String = null;
    public String m_x500String = null;
    public String m_canonicalString = null;
    public String[] m_rdns = null;
    public DERObjectIdentifier[] m_oids = null;
    public int m_count = 0;

    public DNImplRFC2253(DERObjectIdentifier[] newOids, String[] newRdns, int newCount) {
        this.m_oids = newOids;
        this.m_rdns = newRdns;
        this.m_count = newCount;
    }

    public DNImplRFC2253(String name) {
        if (name.startsWith("/")) {
            this.parseX500Int(name);
        } else {
            this.parse(name, true);
        }
    }

    public DNImplRFC2253(String name, boolean reversed) {
        if (name.startsWith("/")) {
            this.parseX500Int(name);
        } else {
            this.parse(name, reversed);
        }
    }

    public DNImplRFC2253(Principal principal) {
        X509Principal x509Principal;
        if (principal instanceof X509Principal) {
            x509Principal = (X509Principal)principal;
        } else if (principal instanceof X500Principal) {
            try {
                x509Principal = new X509Principal(((X500Principal)principal).getEncoded());
            }
            catch (Exception e) {
                LOGGER.error((Object)("Invalid X500Principal DN name: " + principal));
                throw new IllegalArgumentException("Invalid X500Principal DN name: " + principal);
            }
        } else {
            LOGGER.debug((Object)("input is some other principal: " + principal.getClass().getName()));
            String name = principal.getName();
            String testName = name.toLowerCase().trim();
            x509Principal = testName.startsWith("email") || testName.startsWith("e=") || testName.startsWith("cn=") || testName.startsWith("uid=") || testName.startsWith("sn=") ? new X509Principal(true, principal.getName()) : (testName.startsWith("c=") || testName.startsWith("st=") || testName.startsWith("ou=") || testName.startsWith("dc=") ? new X509Principal(false, principal.getName()) : new X509Principal(true, principal.getName()));
        }
        this.m_oids = x509Principal.getOIDs().toArray(new DERObjectIdentifier[0]);
        this.m_rdns = x509Principal.getValues().toArray(new String[0]);
        this.m_count = this.m_oids.length;
    }

    public DNImplRFC2253(X509Name x509Name) {
        this.m_oids = x509Name.getOIDs().toArray(new DERObjectIdentifier[0]);
        this.m_rdns = x509Name.getValues().toArray(new String[0]);
        this.m_count = this.m_oids.length;
    }

    public String getX500() {
        if (this.m_x500String == null) {
            this.constructX500();
        }
        return this.m_x500String;
    }

    public String getRFC2253() {
        return this.constructRFC2253(false, false, DNHandler.s_rfc2253Lookup);
    }

    public String getRFC2253v2() {
        return this.constructRFC2253(false, false, DNHandler.s_rfc2253v2Lookup);
    }

    public String getRFCDN() {
        return this.constructRFC2253(false, true, DNHandler.s_rfc2253Lookup);
    }

    public String getRFCDNv2() {
        return this.constructRFC2253(false, true, DNHandler.s_rfc2253v2Lookup);
    }

    public String getCanon() {
        if (this.m_canonicalString == null) {
            this.constructRFC2253(true);
        }
        return this.m_canonicalString;
    }

    public String constructX500() {
        StringBuffer buf = new StringBuffer();
        for (int n = 0; n < this.m_count; ++n) {
            buf.append('/');
            String rdnSymbol = (String)DNHandler.s_rfc2253Lookup.get(this.m_oids[n]);
            if (rdnSymbol == null) {
                rdnSymbol = this.m_oids[n].toString();
            }
            buf.append(rdnSymbol);
            buf.append('=');
            buf.append(this.m_rdns[n]);
        }
        this.m_x500String = buf.toString();
        return this.m_x500String;
    }

    public String constructRFC2253(boolean canon) {
        return this.constructRFC2253(canon, false, DNHandler.s_rfc2253Lookup);
    }

    private String constructRFC2253(boolean canon, boolean reverse, Hashtable lookup) {
        StringBuffer buf = new StringBuffer();
        boolean first = true;
        if (!reverse) {
            for (int n = 0; n < this.m_count; ++n) {
                this.addRDN(buf, n, first, lookup);
                first = false;
            }
        } else {
            for (int n = this.m_count - 1; n >= 0; --n) {
                this.addRDN(buf, n, first, lookup);
                first = false;
            }
        }
        this.m_rfc2253String = buf.toString();
        this.m_canonicalString = buf.toString().toLowerCase();
        if (canon) {
            return this.m_canonicalString;
        }
        return this.m_rfc2253String;
    }

    private void addRDN(StringBuffer buf, int n, boolean first, Hashtable lookup) {
        String rdnSymbol;
        if (!first) {
            buf.append(',');
        }
        if ((rdnSymbol = (String)lookup.get(this.m_oids[n])) == null) {
            rdnSymbol = this.m_oids[n].toString();
        }
        buf.append(rdnSymbol);
        buf.append('=');
        buf.append(this.m_rdns[n]);
    }

    public void parse(String inputDN) {
        this.parse(inputDN, false);
    }

    private void parse(String inputDN, boolean reversed) {
        X509Principal x509Principal = new X509Principal(reversed, inputDN);
        this.m_oids = x509Principal.getOIDs().toArray(new DERObjectIdentifier[0]);
        this.m_rdns = x509Principal.getValues().toArray(new String[0]);
        this.m_count = this.m_oids.length;
    }

    public void parseX500(String inputDN) {
        this.parseX500Int(inputDN);
    }

    private void parseX500Int(String inputDN) {
        String[] parts = inputDN.split("/");
        if (parts.length < 2) {
            return;
        }
        StringBuffer newInput = new StringBuffer();
        newInput.append(parts[1]);
        for (int i = 2; i < parts.length; ++i) {
            if (parts[i].contains("=")) {
                newInput = newInput.append(", ").append(parts[i]);
                continue;
            }
            newInput.append('/').append(parts[i]);
        }
        X509Principal x509Principal = new X509Principal(false, newInput.toString());
        this.m_oids = x509Principal.getOIDs().toArray(new DERObjectIdentifier[0]);
        this.m_rdns = x509Principal.getValues().toArray(new String[0]);
        this.m_count = this.m_oids.length;
    }

    public boolean equals(Object inputDN2) {
        int n;
        int count;
        DNImplRFC2253 dn2;
        String[] rdns = null;
        DERObjectIdentifier[] oids = null;
        if (inputDN2 instanceof DNImpl) {
            dn2 = (DNImpl)inputDN2;
            count = dn2.m_count;
            rdns = dn2.m_rdns;
            oids = dn2.m_oids;
        } else if (inputDN2 instanceof DNImplRFC2253) {
            dn2 = (DNImplRFC2253)inputDN2;
            count = dn2.m_count;
            rdns = dn2.m_rdns;
            oids = dn2.m_oids;
        } else {
            return false;
        }
        if (this.m_count != count) {
            return false;
        }
        for (n = 0; n < this.m_count; ++n) {
            if (this.m_oids[n].equals((Object)oids[n])) continue;
            return false;
        }
        for (n = 0; n < this.m_count; ++n) {
            if (this.m_rdns[n].toLowerCase().equals(rdns[n].toLowerCase())) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return this.getRFC2253();
    }

    public DN withoutLastCN(boolean checkProxy) {
        if (!this.m_oids[this.m_count - 1].equals((Object)X509Name.CN)) {
            throw new IllegalArgumentException("Trying to remove last CN from DN that does not end in CN. DN was: " + this.toString());
        }
        if (checkProxy && !this.m_rdns[this.m_count - 1].matches("^((limited )?proxy|[0-9]*)$")) {
            throw new IllegalArgumentException("Trying to remove the last proxy CN from DN that does not end in proxy CN. DN was: " + this.toString());
        }
        int newCount = this.m_count - 1;
        String[] newRdns = new String[newCount];
        DERObjectIdentifier[] newOids = new DERObjectIdentifier[newCount];
        for (int n = 0; n < newCount; ++n) {
            newRdns[n] = this.m_rdns[n];
            newOids[n] = this.m_oids[n];
        }
        return new DNImplRFC2253(newOids, newRdns, newCount);
    }

    public int hashCode() {
        return this.m_rdns.hashCode() + this.m_oids.hashCode() + this.m_count;
    }

    public String getLastCNValue() {
        for (int i = this.m_count - 1; i >= 0; --i) {
            if (!this.m_oids[i].equals((Object)X509Name.CN)) continue;
            return this.m_rdns[i];
        }
        return null;
    }

    public boolean isEmpty() {
        return this.m_count == 0;
    }
}

