/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.util;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.PKCS8EncodedKeySpec;
import org.apache.log4j.Logger;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.pkcs.RSAPrivateKeyStructure;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMReader;
import org.bouncycastle.openssl.PasswordFinder;
import org.bouncycastle.util.encoders.Base64;
import org.glite.security.util.Password;

public class PrivateKeyReader {
    private static final Logger LOGGER = Logger.getLogger(PrivateKeyReader.class);
    private static final byte CARR = 13;
    private static final byte NL = 10;
    private static final int BUF_LEN = 1000;
    private static final int MARK_LEN = 10000;
    private static final int LINE_LEN = 64;

    public static PrivateKey read(BufferedInputStream bin, PasswordFinder finder) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(bin));
        return PrivateKeyReader.read(reader, finder);
    }

    public static PrivateKey read(BufferedReader reader, PasswordFinder finder) throws IOException {
        try {
            reader.mark(10000);
            PEMReader pemReader = new PEMReader((Reader)reader, finder, "BC");
            Object o = pemReader.readObject();
            while (o instanceof X509Certificate) {
                o = pemReader.readObject();
            }
            if (o == null) {
                reader.reset();
                PrivateKey key = PrivateKeyReader.backupPKCS8Reader(reader);
                if (key != null) {
                    LOGGER.debug((Object)"Read pkcs8 key with backup implementation");
                    return key;
                }
                reader.reset();
                String line = reader.readLine() + reader.readLine();
                LOGGER.debug((Object)("No key found, first two lines were: " + line));
                throw new IOException("No private key found.");
            }
            PrivateKey privateKey = null;
            if (o instanceof KeyPair) {
                KeyPair pair = (KeyPair)o;
                privateKey = pair.getPrivate();
            } else if (o instanceof PrivateKey) {
                privateKey = (PrivateKey)o;
            } else {
                LOGGER.debug((Object)("Error while reading private key. Item is not a private key. Item is: " + o.getClass()));
                throw new IOException("Error while reading private key. Item is not a private key. Item is: " + o.getClass());
            }
            reader.mark(10000);
            return privateKey;
        }
        catch (IOException e) {
            LOGGER.debug((Object)("Error while reading private key. Exception: " + e.getClass().getName() + " message:" + e.getMessage()));
            throw e;
        }
    }

    public static PrivateKey read(BufferedInputStream bin) throws IOException {
        bin.mark(10000);
        PrivateKey key = PrivateKeyReader.read(bin, (PasswordFinder)null);
        bin.reset();
        if (key != null) {
            bin.skip(100L);
        }
        bin.mark(10000);
        return key;
    }

    public static PrivateKey read(BufferedReader reader) throws IOException {
        return PrivateKeyReader.read(reader, (PasswordFinder)null);
    }

    public static PrivateKey read(BufferedInputStream bin, String passwd) throws IOException {
        bin.mark(10000);
        if (passwd == null) {
            return PrivateKeyReader.read(bin, (PasswordFinder)null);
        }
        return PrivateKeyReader.read(bin, (PasswordFinder)new Password(passwd.toCharArray()));
    }

    public static void skipLine(BufferedInputStream stream) throws IOException {
        byte[] b = new byte[1000];
        stream.mark(1002);
        int num = 0;
        while (stream.available() > 0) {
            int i;
            num = stream.read(b);
            for (i = 0; i < num && b[i] != 13 && b[i] != 10; ++i) {
            }
            stream.reset();
            if (b[i] == 13 || b[i] == 10) {
                stream.skip(i);
                stream.mark(1002);
                break;
            }
            stream.skip(1000L);
            stream.mark(1002);
        }
        num = stream.read(b);
        if (b[0] != 13 && b[0] != 10) {
            LOGGER.error((Object)"No newline char found when trying to skip line");
            throw new IOException("No newline char found when trying to skip line");
        }
        stream.reset();
        if (b[1] == 13 || b[1] == 10 && b[0] != b[1]) {
            stream.skip(2L);
        } else {
            stream.skip(1L);
        }
        stream.mark(1002);
    }

    public static byte[] getEncoded(PrivateKey inKey) {
        if (!(inKey instanceof RSAPrivateCrtKey)) {
            throw new IllegalArgumentException("Argument was:" + inKey.getClass() + " Expected: JCERSAPrivateCrtKey");
        }
        RSAPrivateCrtKey key = (RSAPrivateCrtKey)inKey;
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        DEROutputStream dOut = new DEROutputStream((OutputStream)bOut);
        RSAPrivateKeyStructure info = new RSAPrivateKeyStructure(key.getModulus(), key.getPublicExponent(), key.getPrivateExponent(), key.getPrimeP(), key.getPrimeQ(), key.getPrimeExponentP(), key.getPrimeExponentQ(), key.getCrtCoefficient());
        try {
            dOut.writeObject((Object)info);
            dOut.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Error encoding RSA public key");
        }
        return bOut.toByteArray();
    }

    public static String getPEM(PrivateKey inKey) {
        byte[] bytes = PrivateKeyReader.getEncoded(inKey);
        StringBuffer buffer = new StringBuffer();
        if (inKey instanceof RSAPrivateKey) {
            buffer.append("-----BEGIN RSA PRIVATE KEY-----\n");
            String keyPEM = new String(Base64.encode((byte[])bytes));
            for (int i = 0; i < keyPEM.length(); i += 64) {
                if (keyPEM.length() < i + 64) {
                    buffer.append(keyPEM.substring(i, keyPEM.length()));
                } else {
                    buffer.append(keyPEM.substring(i, i + 64));
                }
                buffer.append("\n");
            }
            buffer.append("-----END RSA PRIVATE KEY-----\n");
            return buffer.toString();
        }
        throw new IllegalArgumentException("Trying to get PEM format string of non-RSA private key, while only RSA is supported. Class was: " + inKey.getClass().getName());
    }

    public static PrivateKey backupPKCS8Reader(BufferedReader reader) throws IOException {
        String line;
        while ((line = reader.readLine()) != null) {
            if (line.indexOf("-----BEGIN PRIVATE KEY") == -1) continue;
            return PrivateKeyReader.readPEM(reader);
        }
        return null;
    }

    private static PrivateKey readPEM(BufferedReader reader) throws IOException {
        String line;
        StringBuffer buf = new StringBuffer();
        while ((line = reader.readLine()) != null && line.indexOf("-----END PRIVATE KEY") == -1) {
            buf.append(line.trim());
        }
        if (line == null) {
            throw new IOException("Private key end marker not found");
        }
        byte[] keyData = Base64.decode((String)buf.toString());
        try {
            PrivateKeyInfo info = PrivateKeyInfo.getInstance((Object)ASN1Object.fromByteArray((byte[])keyData));
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(keyData);
            KeyFactory keyFact = KeyFactory.getInstance(info.getAlgorithmId().getObjectId().getId(), "BC");
            return keyFact.generatePrivate(keySpec);
        }
        catch (Exception e) {
            throw new IOException("problem parsing PRIVATE KEY: " + e.toString());
        }
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }
}

