/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.util.namespace;

import java.io.IOException;
import java.security.cert.CertPathValidatorException;
import java.text.ParseException;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.glite.security.util.DN;
import org.glite.security.util.namespace.DNChecker;
import org.glite.security.util.namespace.EUGridNamespaceFormat;
import org.glite.security.util.namespace.LegacyNamespaceFormat;
import org.glite.security.util.namespace.NamespaceFormat;
import org.glite.security.util.namespace.NamespacePolicy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DNCheckerImpl
implements DNChecker {
    private static final Logger LOGGER = Logger.getLogger(DNCheckerImpl.class);
    private NamespaceFormat namespaceFormat = null;

    public DNCheckerImpl() {
        this(false);
    }

    public DNCheckerImpl(boolean isLegacy) {
        this.namespaceFormat = isLegacy ? new LegacyNamespaceFormat() : new EUGridNamespaceFormat();
    }

    public DNCheckerImpl(NamespaceFormat namespaceFormat) {
        this.namespaceFormat = namespaceFormat;
    }

    @Override
    public void read(String fileName) throws IOException, ParseException {
        this.namespaceFormat.parse(fileName);
    }

    @Override
    public void check(DN subjectDN, DN issuerDN, List<NamespacePolicy> prevPolicies) throws CertPathValidatorException {
        List<NamespacePolicy> policyList = this.namespaceFormat.getPolices();
        if (prevPolicies != null) {
            for (NamespacePolicy p : prevPolicies) {
                policyList.add(p);
            }
        }
        boolean matches = false;
        NamespacePolicy failedPolicy = null;
        boolean issuerMatches = false;
        for (NamespacePolicy policy : policyList) {
            LOGGER.debug((Object)("Checking against policy: " + policy));
            String subjectPolicyDN = policy.getSubjectDN();
            DN issuerPolicyDN = policy.getIssuerDN();
            subjectPolicyDN = this.cleanupDN(subjectPolicyDN);
            if (issuerPolicyDN.equals(issuerDN)) {
                LOGGER.debug((Object)("Issuer matches " + issuerPolicyDN));
                issuerMatches = true;
                if (Pattern.matches(subjectPolicyDN, this.cleanupDN(subjectDN.getX500().toLowerCase()))) {
                    LOGGER.debug((Object)("Subject matches " + subjectPolicyDN));
                    if (!policy.isSubjectDNPermitted()) {
                        LOGGER.debug((Object)"Policy is deny, rejecting the DN.");
                        failedPolicy = policy;
                        break;
                    }
                    matches = true;
                    continue;
                }
                LOGGER.debug((Object)("Subject doesn't match " + subjectPolicyDN));
                continue;
            }
            LOGGER.debug((Object)("Issuer doesn't match " + issuerPolicyDN));
        }
        if (failedPolicy != null) {
            throw new CertPathValidatorException(subjectDN.getX500() + " is denied in the namespace policy line: " + failedPolicy.getPolicyStatement() + " from file: " + failedPolicy.getFilename());
        }
        if (matches) {
            LOGGER.debug((Object)"DN is allowed.");
        }
        if (!matches && !policyList.isEmpty()) {
            if (issuerMatches) {
                throw new CertPathValidatorException("User: " + subjectDN.getX500() + " is not listed as allowed for issuer: " + issuerDN.getX500());
            }
            throw new CertPathValidatorException("Namespace policy defined, but issuer \"" + issuerDN.getX500() + "\" is not in it.");
        }
    }

    private String cleanupDN(String dn) {
        String newDN = dn;
        if (!newDN.contains(".*") && newDN.contains("*")) {
            newDN = newDN.replace("*", ".*");
        }
        if (newDN.contains("(")) {
            newDN = newDN.replace("(", "");
        }
        if (dn.contains(")")) {
            newDN = newDN.replace(")", "");
        }
        return newDN;
    }
}

