/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.util.proxy;

import java.math.BigInteger;
import java.util.Vector;
import java.util.regex.Pattern;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.x509.X509Name;
import org.glite.security.util.DN;

public class ProxyCertUtil {
    public static void checkProxyDN(DN parent, DN proxy) throws IllegalArgumentException {
        DN baseDNFromProxySubject = proxy.withoutLastCN(true);
        if (!parent.equals(baseDNFromProxySubject)) {
            throw new IllegalArgumentException("The proxy DN (" + proxy + ") violates a policy that it should be constructed from parent DN (" + parent + ") and an additional CN component");
        }
    }

    public static BigInteger getSN(X509Name dn) {
        String sn;
        Vector oids = dn.getOIDs();
        DERObjectIdentifier oid = (DERObjectIdentifier)oids.elementAt(0);
        BigInteger bi = ProxyCertUtil.testGetSN(oid, sn = (String)dn.getValues().elementAt(0));
        if (bi != null) {
            return bi;
        }
        oid = (DERObjectIdentifier)oids.elementAt(oids.size() - 1);
        sn = (String)dn.getValues().elementAt(oids.size() - 1);
        return ProxyCertUtil.testGetSN(oid, sn);
    }

    private static BigInteger testGetSN(DERObjectIdentifier oid, String value) {
        if (oid == X509Name.CN && Pattern.matches("\\d*", value)) {
            return new BigInteger(value);
        }
        return null;
    }
}

