/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.util.proxy;

import java.io.IOException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.x509.X509Name;
import org.glite.security.util.CertUtil;
import org.glite.security.util.proxy.ProxyCertInfoExtension;
import org.glite.security.util.proxy.ProxyPolicy;
import org.glite.security.util.proxy.ProxyRestrictionData;
import org.glite.security.util.proxy.ProxyTracingExtension;
import org.glite.security.util.proxy.SAMLExtension;

public class ProxyCertificateInfo {
    public static final int LEGACY_PROXY = 52;
    public static final int DRAFT_RFC_PROXY = 53;
    public static final int RFC3820_PROXY = 54;
    public static final int CA_CERT = 71;
    public static final int USER_CERT = 72;
    public static final int UNKNOWN_PROXY_TYPE = 99;
    public static final int UNDEFINED_TYPE = -1;
    private int m_proxyType = -1;
    private X509Certificate m_cert;

    public ProxyCertificateInfo(X509Certificate x509Cert) {
        this.m_cert = x509Cert;
    }

    public int getProxyType() {
        if (this.m_proxyType != -1) {
            return this.m_proxyType;
        }
        if (this.m_cert.getExtensionValue("1.3.6.1.5.5.7.1.14") != null && this.m_cert.getExtensionValue("1.3.6.1.5.5.7.1.14").length > 0) {
            this.m_proxyType = 54;
            return this.m_proxyType;
        }
        if (this.m_cert.getExtensionValue("1.3.6.1.4.1.3536.1.1.222") != null && this.m_cert.getExtensionValue("1.3.6.1.4.1.3536.1.1.222").length > 0) {
            this.m_proxyType = 53;
            return this.m_proxyType;
        }
        X509Name subject = (X509Name)this.m_cert.getSubjectDN();
        DERObjectIdentifier oid = (DERObjectIdentifier)subject.getOIDs().lastElement();
        if (!X509Name.CN.equals((Object)oid)) {
            this.m_proxyType = 99;
            return this.m_proxyType;
        }
        String value = (String)subject.getValues().lastElement();
        if ("proxy".equals(value.toLowerCase()) || "limited proxy".equals(value.toLowerCase())) {
            this.m_proxyType = 52;
            return this.m_proxyType;
        }
        this.m_proxyType = 99;
        return this.m_proxyType;
    }

    public static boolean isLegacyDN(X509Name subject) {
        DERObjectIdentifier oid = (DERObjectIdentifier)subject.getOIDs().lastElement();
        if (oid != X509Name.CN) {
            return false;
        }
        String value = (String)subject.getValues().lastElement();
        return "proxy".equals(value.toLowerCase()) || "limited proxy".equals(value.toLowerCase());
    }

    public boolean isLimited() throws CertificateException, IOException {
        if (this.m_proxyType == -1) {
            this.getProxyType();
        }
        if (this.m_proxyType == 52) {
            X509Name subject = (X509Name)this.m_cert.getSubjectDN();
            DERObjectIdentifier oid = (DERObjectIdentifier)subject.getOIDs().lastElement();
            if (oid != X509Name.CN) {
                throw new CertificateException("The certificate DN doesn't end with CN RDN as required for legacy proxies");
            }
            String value = (String)subject.getValues().lastElement();
            return "limited proxy".equals(value.toLowerCase());
        }
        if (this.m_proxyType == 54 || this.m_proxyType == 53) {
            String policyOID = this.getProxyPolicyOID();
            return policyOID.equals("1.3.6.1.4.1.3536.1.1.1.9");
        }
        throw new CertificateException("Can't determine whether the proxy is limited as it isn't legacy proxy or rfc 3820 proxy and thus unsupported or invalid");
    }

    public String getProxyTracingIssuer() throws IOException {
        byte[] bytes = CertUtil.getExtensionBytes(this.m_cert, "1.2.840.113612.5.5.1.1.1.1");
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        ProxyTracingExtension extension = new ProxyTracingExtension(bytes);
        return extension.getURL();
    }

    public String getProxyTracingSubject() throws IOException {
        byte[] bytes = CertUtil.getExtensionBytes(this.m_cert, "1.2.840.113612.5.5.1.1.1.2");
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        ProxyTracingExtension extension = new ProxyTracingExtension(bytes);
        return extension.getURL();
    }

    public String getSAMLExtension() throws IOException {
        byte[] bytes = CertUtil.getExtensionBytes(this.m_cert, "1.3.6.1.4.1.3536.1.1.1.12");
        if (bytes == null || bytes.length == 0) {
            bytes = CertUtil.getExtensionBytes(this.m_cert, "1.3.6.1.4.1.3536.1.1.1.10");
        }
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        SAMLExtension extension = new SAMLExtension(bytes);
        return extension.getSAML();
    }

    public ProxyCertInfoExtension getProxyCertInfoExtension() throws CertificateException, IOException {
        if (this.getProxyType() != 54 && this.getProxyType() != 53) {
            throw new CertificateException("Trying to get proxyPathLimit from legacy or unsupported proxy type");
        }
        byte[] bytes = CertUtil.getExtensionBytes(this.m_cert, "1.3.6.1.5.5.7.1.14");
        if (bytes == null) {
            bytes = CertUtil.getExtensionBytes(this.m_cert, "1.3.6.1.4.1.3536.1.1.222");
        }
        if (bytes == null) {
            throw new CertificateException("The mandatory CertificateInfoExtention is missing, certificate is invalid RFC 3820 or draft RFC certificate.");
        }
        return new ProxyCertInfoExtension(bytes);
    }

    public int getProxyPathLimit() throws CertificateException, IOException {
        ProxyCertInfoExtension extension = this.getProxyCertInfoExtension();
        return extension.getProxyPathLimit();
    }

    public String getProxyPolicyOID() throws CertificateException, IOException {
        ProxyCertInfoExtension extension = this.getProxyCertInfoExtension();
        ProxyPolicy policy = extension.getPolicy();
        return policy.getPolicyOID();
    }

    public ASN1OctetString getPolicyASN1() throws CertificateException, IOException {
        ProxyCertInfoExtension extension = this.getProxyCertInfoExtension();
        ProxyPolicy policy = extension.getPolicy();
        return policy.getPolicyASN1();
    }

    public ProxyRestrictionData getProxySourceRestrictions() throws IOException {
        byte[] bytes = CertUtil.getExtensionBytes(this.m_cert, "1.2.840.113612.5.5.1.1.2.1");
        if (bytes == null) {
            return null;
        }
        return new ProxyRestrictionData(bytes);
    }

    public ProxyRestrictionData getProxyTargetRestrictions() throws IOException {
        byte[] bytes = CertUtil.getExtensionBytes(this.m_cert, "1.2.840.113612.5.5.1.1.2.2");
        if (bytes == null) {
            return null;
        }
        return new ProxyRestrictionData(bytes);
    }
}

