/*
 * Decompiled with CFR 0.152.
 */
package eu.toolchain.serializer.processor;

import com.google.auto.service.AutoService;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableSet;
import com.squareup.javapoet.JavaFile;
import eu.toolchain.serializer.processor.AutoSerializeAbstractProcessor;
import eu.toolchain.serializer.processor.AutoSerializeClassProcessor;
import eu.toolchain.serializer.processor.AutoSerializeUtils;
import eu.toolchain.serializer.processor.DeferredProcessing;
import eu.toolchain.serializer.processor.FrameworkStatements;
import eu.toolchain.serializer.processor.PrefixingMessager;
import eu.toolchain.serializer.processor.annotation.AutoSerializeMirror;
import eu.toolchain.serializer.processor.unverified.Unverified;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;

@AutoService(value=Processor.class)
public class AutoSerializeProcessor
extends AbstractProcessor {
    private Filer filer;
    private Messager messager;
    private AutoSerializeUtils utils;
    private FrameworkStatements statements;
    private AutoSerializeAbstractProcessor abstractProcessor;
    private AutoSerializeClassProcessor classProcessor;
    private final List<DeferredProcessing> deferred = new ArrayList<DeferredProcessing>();

    @Override
    public void init(ProcessingEnvironment env) {
        super.init(env);
        this.filer = env.getFiler();
        this.messager = new PrefixingMessager("@AutoSerialize", env.getMessager());
        Elements elements = env.getElementUtils();
        Types types = env.getTypeUtils();
        this.utils = new AutoSerializeUtils(types, elements);
        this.statements = new FrameworkStatements(this.utils);
        this.abstractProcessor = new AutoSerializeAbstractProcessor(elements, this.statements, this.utils);
        this.classProcessor = new AutoSerializeClassProcessor(types, elements, this.statements, this.utils);
        if (env.getClass().getPackage().getName().startsWith("org.eclipse.jdt.")) {
            this.warnAboutBugEclipse300408();
        }
    }

    void warnAboutBugEclipse300408() {
        this.messager.printMessage(Diagnostic.Kind.WARNING, "@AutoSerialize processor might not work properly in Eclipse < 3.5, see https://bugs.eclipse.org/bugs/show_bug.cgi?id=300408");
    }

    @Override
    public boolean process(Set<? extends TypeElement> typeElements, RoundEnvironment env) {
        ImmutableSet.Builder elementsToProcess = ImmutableSet.builder();
        if (env.processingOver()) {
            for (DeferredProcessing deferredProcessing : this.deferred) {
                deferredProcessing.getBroken().get().writeError(this.messager);
            }
            return false;
        }
        if (!this.deferred.isEmpty()) {
            elementsToProcess.addAll(this.deferred.stream().map(DeferredProcessing.refresh(this.utils)).iterator());
            this.deferred.clear();
        }
        for (Element element : env.getElementsAnnotatedWith(this.utils.autoSerializeType())) {
            if (!(element instanceof TypeElement)) {
                this.messager.printMessage(Diagnostic.Kind.WARNING, String.format("Skipping non-type element %s", element));
                continue;
            }
            elementsToProcess.add((Object)new DeferredProcessing((TypeElement)element, Optional.empty()));
        }
        List<Processed> processed = this.processElements((Set<DeferredProcessing>)elementsToProcess.build());
        for (Processed p : processed) {
            Unverified<JavaFile> serializer = p.getFile();
            if (!serializer.isVerified()) {
                this.deferred.add(p.processing.withBroken(serializer));
                continue;
            }
            try {
                serializer.get().writeTo(this.filer);
            }
            catch (Exception e) {
                this.messager.printMessage(Diagnostic.Kind.ERROR, "Failed to write:\n" + Throwables.getStackTraceAsString((Throwable)e), p.getProcessing().getElement());
            }
        }
        return false;
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return ImmutableSet.of((Object)AutoSerializeUtils.AUTOSERIALIZE);
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    List<Processed> processElements(Set<DeferredProcessing> elements) {
        ArrayList<Processed> processed = new ArrayList<Processed>();
        for (DeferredProcessing processing : elements) {
            Unverified<JavaFile> result = this.processElement(processing.getElement());
            processed.add(new Processed(result, processing));
        }
        return processed;
    }

    Unverified<JavaFile> processElement(TypeElement element) {
        Optional<Unverified<AutoSerializeMirror>> annotation = this.utils.autoSerialize(element);
        if (!annotation.isPresent()) {
            return Unverified.brokenElement("@AutoSerialize annotation not present", element);
        }
        Unverified<AutoSerializeMirror> unverifiedAutoSerialize = annotation.get();
        return unverifiedAutoSerialize.transform(autoSerialize -> {
            if (element.getKind() == ElementKind.INTERFACE) {
                if (autoSerialize.getBuilder().isPresent()) {
                    return this.classProcessor.process(element, (AutoSerializeMirror)autoSerialize);
                }
                return this.abstractProcessor.process(element, (AutoSerializeMirror)autoSerialize);
            }
            if (element.getKind() == ElementKind.CLASS) {
                if (element.getModifiers().contains((Object)Modifier.ABSTRACT) && !autoSerialize.getBuilder().isPresent()) {
                    return this.abstractProcessor.process(element, (AutoSerializeMirror)autoSerialize);
                }
                return this.classProcessor.process(element, (AutoSerializeMirror)autoSerialize);
            }
            return Unverified.brokenElement("Unsupported type, expected class or interface", element);
        });
    }

    public static class Processed {
        final Unverified<JavaFile> file;
        final DeferredProcessing processing;

        @ConstructorProperties(value={"file", "processing"})
        public Processed(Unverified<JavaFile> file, DeferredProcessing processing) {
            this.file = file;
            this.processing = processing;
        }

        public Unverified<JavaFile> getFile() {
            return this.file;
        }

        public DeferredProcessing getProcessing() {
            return this.processing;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Processed)) {
                return false;
            }
            Processed other = (Processed)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Unverified<JavaFile> this$file = this.getFile();
            Unverified<JavaFile> other$file = other.getFile();
            if (this$file == null ? other$file != null : !this$file.equals(other$file)) {
                return false;
            }
            DeferredProcessing this$processing = this.getProcessing();
            DeferredProcessing other$processing = other.getProcessing();
            return !(this$processing == null ? other$processing != null : !((Object)this$processing).equals(other$processing));
        }

        public boolean canEqual(Object other) {
            return other instanceof Processed;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Unverified<JavaFile> $file = this.getFile();
            result = result * 59 + ($file == null ? 0 : $file.hashCode());
            DeferredProcessing $processing = this.getProcessing();
            result = result * 59 + ($processing == null ? 0 : ((Object)$processing).hashCode());
            return result;
        }

        public String toString() {
            return "AutoSerializeProcessor.Processed(file=" + this.getFile() + ", processing=" + this.getProcessing() + ")";
        }
    }
}

