/*
 * Decompiled with CFR 0.152.
 */
package eu.toolchain.serializer.processor;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.TypeName;
import eu.toolchain.serializer.processor.AutoSerializeUtils;
import eu.toolchain.serializer.processor.FrameworkMethodBuilder;
import eu.toolchain.serializer.processor.FrameworkStatement;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.UUID;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.SimpleTypeVisitor6;

public class FrameworkStatements {
    static final Map<TypeName, String> direct = new HashMap<TypeName, String>();
    static final Map<TypeName, Parameterized> parameterized;
    private final AutoSerializeUtils utils;
    static Joiner argumentJoiner;

    public FrameworkStatement resolveStatement(TypeMirror type, Object framework) {
        String statement = direct.get(TypeName.get((TypeMirror)type));
        if (statement != null) {
            return builder -> builder.assign(statement, (List<Object>)ImmutableList.of((Object)framework));
        }
        if (type instanceof ArrayType) {
            ArrayType a = (ArrayType)type;
            return this.resolveArrayType(a, framework);
        }
        if (type.getKind() != TypeKind.DECLARED) {
            throw new IllegalArgumentException("Cannot handle type: " + type);
        }
        DeclaredType d = (DeclaredType)type;
        if (d.asElement().getKind() == ElementKind.ENUM) {
            return this.resolveEnum((TypeElement)d.asElement(), framework);
        }
        if (d.getTypeArguments().isEmpty()) {
            return this.resolveCustomSerializer(d, framework);
        }
        return this.resolveParameterizedType(d, framework);
    }

    private FrameworkStatement resolveArrayType(ArrayType a, Object framework) {
        TypeMirror componentType = a.getComponentType();
        if (this.utils.isPrimitive(componentType)) {
            throw new IllegalArgumentException("Cannot serialize array with a primitive component type: " + a);
        }
        FrameworkStatement component = this.resolveStatement(this.utils.boxedIfNeeded(componentType), framework);
        TypeName innerMost = TypeName.get((TypeMirror)this.arrayInnerMost(componentType));
        String parens = this.arrayParensAfterSize(componentType);
        return builder -> component.writeTo((cs, ca) -> {
            ArrayList<Object> arguments = new ArrayList<Object>();
            arguments.add(framework);
            arguments.add(componentType);
            arguments.addAll(ca);
            arguments.add(innerMost);
            builder.assign(String.format("$N.<$T>array(%s, (s) -> new $T[s]%s)", cs, parens), arguments);
        });
    }

    private String arrayParensAfterSize(TypeMirror t) {
        return t.accept(new SimpleTypeVisitor6<String, Void>(){

            @Override
            public String visitArray(ArrayType t, Void p) {
                return "[]" + FrameworkStatements.this.arrayParensAfterSize(t.getComponentType());
            }

            @Override
            protected String defaultAction(TypeMirror e, Void p) {
                return "";
            }
        }, null);
    }

    private TypeMirror arrayInnerMost(TypeMirror t) {
        return t.accept(new SimpleTypeVisitor6<TypeMirror, Void>(){

            @Override
            public TypeMirror visitArray(ArrayType t, Void p) {
                return FrameworkStatements.this.arrayInnerMost(t.getComponentType());
            }

            @Override
            protected TypeMirror defaultAction(TypeMirror e, Void p) {
                return e;
            }
        }, null);
    }

    private FrameworkStatement resolveEnum(TypeElement element, Object framework) {
        ClassName enumType = ClassName.get((TypeElement)element);
        return builder -> builder.assign("$N.forEnum($T.values())", (List<Object>)ImmutableList.of((Object)framework, (Object)enumType));
    }

    FrameworkStatement resolveGeneric(String statementBase, List<Object> argumentsBase, List<FrameworkStatement> statements) {
        ArrayList typeStatements = new ArrayList();
        ImmutableList.Builder outerArguments = ImmutableList.builder();
        outerArguments.addAll(argumentsBase);
        for (FrameworkStatement a : statements) {
            a.writeTo((statement, arguments) -> {
                typeStatements.add(statement);
                outerArguments.addAll((Iterable)arguments);
            });
        }
        String statement2 = String.format("%s(%s)", statementBase, argumentJoiner.join(typeStatements));
        ImmutableList arguments2 = outerArguments.build();
        return arg_0 -> FrameworkStatements.lambda$resolveGeneric$38(statement2, (List)arguments2, arg_0);
    }

    FrameworkStatement resolveCustomSerializer(DeclaredType type, Object framework) {
        String statement = "new $T($N)";
        ImmutableList arguments = ImmutableList.of((Object)this.utils.serializerClassFor(type), (Object)framework);
        return arg_0 -> FrameworkStatements.lambda$resolveCustomSerializer$39((List)arguments, arg_0);
    }

    private ParameterizedMatch findBestMatch(DeclaredType type) {
        DeclaredType t;
        TypeElement e;
        ClassName c;
        Parameterized p;
        LinkedList<DeclaredType> types = new LinkedList<DeclaredType>();
        types.add(type);
        TreeSet<ParameterizedMatch> matches = new TreeSet<ParameterizedMatch>();
        while (!types.isEmpty() && (p = parameterized.get(c = ClassName.get((TypeElement)(e = (TypeElement)(t = (DeclaredType)types.poll()).asElement())))) != null) {
            matches.add(new ParameterizedMatch(p, t));
        }
        if (matches.isEmpty()) {
            throw new IllegalArgumentException("Type not supported: " + type);
        }
        return (ParameterizedMatch)matches.last();
    }

    private FrameworkStatement resolveParameterizedType(DeclaredType type, Object framework) {
        ParameterizedMatch p = this.findBestMatch(type);
        Iterator<? extends TypeMirror> typeArguments = p.type.getTypeArguments().iterator();
        ImmutableList.Builder statements = ImmutableList.builder();
        for (int i = 0; i < p.parameterized.parameterCount; ++i) {
            statements.add((Object)this.resolveStatement(typeArguments.next(), framework));
        }
        return this.resolveGeneric(p.parameterized.statement, (List<Object>)ImmutableList.of((Object)framework), (List<FrameworkStatement>)statements.build());
    }

    @ConstructorProperties(value={"utils"})
    public FrameworkStatements(AutoSerializeUtils utils) {
        this.utils = utils;
    }

    private static /* synthetic */ void lambda$resolveCustomSerializer$39(List arguments, FrameworkMethodBuilder builder) {
        builder.assign("new $T($N)", arguments);
    }

    private static /* synthetic */ void lambda$resolveGeneric$38(String statement, List arguments, FrameworkMethodBuilder builder) {
        builder.assign(statement, arguments);
    }

    static {
        direct.put((TypeName)ClassName.get(String.class), "$N.string()");
        direct.put((TypeName)ClassName.get(Byte.class), "$N.fixedByte()");
        direct.put((TypeName)ClassName.get(Short.class), "$N.fixedShort()");
        direct.put((TypeName)ClassName.get(Integer.class), "$N.fixedInteger()");
        direct.put((TypeName)ClassName.get(Long.class), "$N.fixedLong()");
        direct.put((TypeName)ClassName.get(Float.class), "$N.fixedFloat()");
        direct.put((TypeName)ClassName.get(Double.class), "$N.fixedDouble()");
        direct.put((TypeName)ClassName.get(Character.class), "$N.fixedCharacter()");
        direct.put((TypeName)ClassName.get(Boolean.class), "$N.fixedBoolean()");
        direct.put((TypeName)ClassName.get(UUID.class), "$N.uuid()");
        direct.put(TypeName.get(boolean[].class), "$N.booleanArray()");
        direct.put(TypeName.get(byte[].class), "$N.byteArray()");
        direct.put(TypeName.get(short[].class), "$N.shortArray()");
        direct.put(TypeName.get(int[].class), "$N.intArray()");
        direct.put(TypeName.get(long[].class), "$N.longArray()");
        direct.put(TypeName.get(float[].class), "$N.floatArray()");
        direct.put(TypeName.get(double[].class), "$N.doubleArray()");
        direct.put(TypeName.get(char[].class), "$N.charArray()");
        parameterized = new HashMap<TypeName, Parameterized>();
        parameterized.put((TypeName)ClassName.get(List.class), new Parameterized("$N.list", 1));
        parameterized.put((TypeName)ClassName.get(Map.class), new Parameterized("$N.map", 2));
        parameterized.put((TypeName)ClassName.get(SortedMap.class), new Parameterized("$N.sortedMap", 2, 2));
        parameterized.put((TypeName)ClassName.get(NavigableMap.class), new Parameterized("$N.navigableMap", 2, 2));
        parameterized.put((TypeName)ClassName.get(Set.class), new Parameterized("$N.set", 1));
        parameterized.put((TypeName)ClassName.get(SortedSet.class), new Parameterized("$N.sortedSet", 1, 2));
        parameterized.put((TypeName)ClassName.get(NavigableSet.class), new Parameterized("$N.navigableSet", 1, 2));
        parameterized.put((TypeName)ClassName.get(Optional.class), new Parameterized("$N.optional", 1));
        argumentJoiner = Joiner.on((String)", ");
    }

    static class ParameterizedMatch
    implements Comparable<ParameterizedMatch> {
        final Parameterized parameterized;
        final DeclaredType type;

        @Override
        public int compareTo(ParameterizedMatch o) {
            return this.parameterized.compareTo(o.parameterized);
        }

        @ConstructorProperties(value={"parameterized", "type"})
        public ParameterizedMatch(Parameterized parameterized, DeclaredType type) {
            this.parameterized = parameterized;
            this.type = type;
        }
    }

    static class Parameterized
    implements Comparable<Parameterized> {
        final String statement;
        final int parameterCount;
        final int priority;

        public Parameterized(String statement, int parameterCount) {
            this(statement, parameterCount, 0);
        }

        public Parameterized(String statement, int parameterCount, int priority) {
            this.statement = statement;
            this.parameterCount = parameterCount;
            this.priority = priority;
        }

        @Override
        public int compareTo(Parameterized o) {
            return Integer.compare(this.priority, o.priority);
        }
    }
}

