/*
 * Decompiled with CFR 0.152.
 */
package eu.toolchain.serializer.processor.annotation;

import eu.toolchain.serializer.processor.AutoSerializeUtils;
import eu.toolchain.serializer.processor.annotation.AnnotationValues;
import eu.toolchain.serializer.processor.unverified.Unverified;
import java.beans.ConstructorProperties;
import java.util.Optional;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.type.TypeMirror;

public class BuilderMirror {
    private final AnnotationMirror annotation;
    private final boolean useSetter;
    private final boolean useMethod;
    private final boolean useConstructor;
    private final Optional<AnnotationValues.Value<TypeMirror>> type;
    private final String methodName;

    public static Unverified<BuilderMirror> getFor(AutoSerializeUtils utils, Element element, AnnotationMirror a) {
        AnnotationValues values = utils.getElementValuesWithDefaults(element, a);
        boolean useSetter = values.getBoolean("useSetter").get();
        boolean useMethod = values.getBoolean("useMethod").get();
        boolean useConstructor = values.getBoolean("useConstructor").get();
        String methodName = values.getString("methodName").get();
        Unverified<AnnotationValues.Value<TypeMirror>> unverifiedType = values.getTypeMirror("type");
        return unverifiedType.map(type -> {
            Optional<AnnotationValues.Value<TypeMirror>> typeMirror = Optional.of(type).filter(t -> !((TypeMirror)t.get()).toString().equals(AutoSerializeUtils.DEFAULT_BUILDER_TYPE));
            return new BuilderMirror(a, useSetter, useMethod, useConstructor, typeMirror, methodName);
        });
    }

    public boolean shouldUseConstructor() {
        if (this.useMethod) {
            return false;
        }
        if (this.useConstructor) {
            return true;
        }
        return this.type.isPresent();
    }

    @ConstructorProperties(value={"annotation", "useSetter", "useMethod", "useConstructor", "type", "methodName"})
    public BuilderMirror(AnnotationMirror annotation, boolean useSetter, boolean useMethod, boolean useConstructor, Optional<AnnotationValues.Value<TypeMirror>> type, String methodName) {
        this.annotation = annotation;
        this.useSetter = useSetter;
        this.useMethod = useMethod;
        this.useConstructor = useConstructor;
        this.type = type;
        this.methodName = methodName;
    }

    public AnnotationMirror getAnnotation() {
        return this.annotation;
    }

    public boolean isUseSetter() {
        return this.useSetter;
    }

    public boolean isUseMethod() {
        return this.useMethod;
    }

    public boolean isUseConstructor() {
        return this.useConstructor;
    }

    public Optional<AnnotationValues.Value<TypeMirror>> getType() {
        return this.type;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BuilderMirror)) {
            return false;
        }
        BuilderMirror other = (BuilderMirror)o;
        if (!other.canEqual(this)) {
            return false;
        }
        AnnotationMirror this$annotation = this.getAnnotation();
        AnnotationMirror other$annotation = other.getAnnotation();
        if (this$annotation == null ? other$annotation != null : !this$annotation.equals(other$annotation)) {
            return false;
        }
        if (this.isUseSetter() != other.isUseSetter()) {
            return false;
        }
        if (this.isUseMethod() != other.isUseMethod()) {
            return false;
        }
        if (this.isUseConstructor() != other.isUseConstructor()) {
            return false;
        }
        Optional<AnnotationValues.Value<TypeMirror>> this$type = this.getType();
        Optional<AnnotationValues.Value<TypeMirror>> other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)this$type).equals(other$type)) {
            return false;
        }
        String this$methodName = this.getMethodName();
        String other$methodName = other.getMethodName();
        return !(this$methodName == null ? other$methodName != null : !this$methodName.equals(other$methodName));
    }

    public boolean canEqual(Object other) {
        return other instanceof BuilderMirror;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        AnnotationMirror $annotation = this.getAnnotation();
        result = result * 59 + ($annotation == null ? 0 : $annotation.hashCode());
        result = result * 59 + (this.isUseSetter() ? 79 : 97);
        result = result * 59 + (this.isUseMethod() ? 79 : 97);
        result = result * 59 + (this.isUseConstructor() ? 79 : 97);
        Optional<AnnotationValues.Value<TypeMirror>> $type = this.getType();
        result = result * 59 + ($type == null ? 0 : ((Object)$type).hashCode());
        String $methodName = this.getMethodName();
        result = result * 59 + ($methodName == null ? 0 : $methodName.hashCode());
        return result;
    }

    public String toString() {
        return "BuilderMirror(annotation=" + this.getAnnotation() + ", useSetter=" + this.isUseSetter() + ", useMethod=" + this.isUseMethod() + ", useConstructor=" + this.isUseConstructor() + ", type=" + this.getType() + ", methodName=" + this.getMethodName() + ")";
    }
}

