/*
 * Decompiled with CFR 0.152.
 */
package eu.toolchain.serializer.processor.annotation;

import com.google.common.collect.ImmutableList;
import eu.toolchain.serializer.processor.AutoSerializeUtils;
import eu.toolchain.serializer.processor.annotation.AnnotationValues;
import eu.toolchain.serializer.processor.annotation.SubTypeMirror;
import eu.toolchain.serializer.processor.unverified.Unverified;
import java.beans.ConstructorProperties;
import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;

public class SubTypesMirror {
    private final AnnotationMirror annotation;
    private final List<SubTypeMirror> subTypes;

    public static Unverified<SubTypesMirror> getFor(AutoSerializeUtils utils, Element element, AnnotationMirror a) {
        AnnotationValues values = utils.getElementValuesWithDefaults(element, a);
        ImmutableList.Builder unverifiedSubTypes = ImmutableList.builder();
        for (AnnotationMirror subType : values.getAnnotationValue("value").get()) {
            unverifiedSubTypes.add(SubTypeMirror.getFor(utils, element, subType));
        }
        return Unverified.combine(unverifiedSubTypes.build()).map(subTypes -> new SubTypesMirror(a, (List<SubTypeMirror>)subTypes));
    }

    @ConstructorProperties(value={"annotation", "subTypes"})
    public SubTypesMirror(AnnotationMirror annotation, List<SubTypeMirror> subTypes) {
        this.annotation = annotation;
        this.subTypes = subTypes;
    }

    public AnnotationMirror getAnnotation() {
        return this.annotation;
    }

    public List<SubTypeMirror> getSubTypes() {
        return this.subTypes;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SubTypesMirror)) {
            return false;
        }
        SubTypesMirror other = (SubTypesMirror)o;
        if (!other.canEqual(this)) {
            return false;
        }
        AnnotationMirror this$annotation = this.getAnnotation();
        AnnotationMirror other$annotation = other.getAnnotation();
        if (this$annotation == null ? other$annotation != null : !this$annotation.equals(other$annotation)) {
            return false;
        }
        List<SubTypeMirror> this$subTypes = this.getSubTypes();
        List<SubTypeMirror> other$subTypes = other.getSubTypes();
        return !(this$subTypes == null ? other$subTypes != null : !((Object)this$subTypes).equals(other$subTypes));
    }

    public boolean canEqual(Object other) {
        return other instanceof SubTypesMirror;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        AnnotationMirror $annotation = this.getAnnotation();
        result = result * 59 + ($annotation == null ? 0 : $annotation.hashCode());
        List<SubTypeMirror> $subTypes = this.getSubTypes();
        result = result * 59 + ($subTypes == null ? 0 : ((Object)$subTypes).hashCode());
        return result;
    }

    public String toString() {
        return "SubTypesMirror(annotation=" + this.getAnnotation() + ", subTypes=" + this.getSubTypes() + ")";
    }
}

