/*
 * Decompiled with CFR 0.152.
 */
package eu.toolchain.serializer.processor.unverified;

import com.google.common.collect.ImmutableList;
import eu.toolchain.serializer.processor.unverified.AbstractVerified;
import eu.toolchain.serializer.processor.unverified.BrokenAnnotation;
import eu.toolchain.serializer.processor.unverified.BrokenAnnotationValue;
import eu.toolchain.serializer.processor.unverified.BrokenElement;
import eu.toolchain.serializer.processor.unverified.Verified;
import java.util.List;
import java.util.function.Function;
import javax.annotation.processing.Messager;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;

public interface Unverified<T> {
    public T get();

    public boolean isVerified();

    public void writeError(Messager var1);

    public <O> Unverified<O> map(Function<? super T, ? extends O> var1);

    public <O> Unverified<O> transform(Function<? super T, ? extends Unverified<O>> var1);

    public T orElse(T var1);

    public static <T> Unverified<T> verified(T reference) {
        return new Verified<T>(reference);
    }

    public static <T> Unverified<T> brokenElement(String message, Element element) {
        return new BrokenElement(message, element);
    }

    public static <T> Unverified<T> brokenAnnotation(String message, Element element, AnnotationMirror annotation) {
        return new BrokenAnnotation(message, element, annotation);
    }

    public static <T> Unverified<T> brokenAnnotationValue(String message, Element element, AnnotationMirror annotation, AnnotationValue value) {
        return new BrokenAnnotationValue(message, element, annotation, value);
    }

    public static <T> Unverified<List<T>> combine(final Iterable<? extends Unverified<T>> maybes) {
        return new AbstractVerified<List<T>>(){

            @Override
            public List<T> get() {
                ImmutableList.Builder result = ImmutableList.builder();
                for (Unverified m : maybes) {
                    result.add(m.get());
                }
                return result.build();
            }

            @Override
            public boolean isVerified() {
                boolean verified = true;
                for (Unverified m : maybes) {
                    verified = verified && m.isVerified();
                }
                return verified;
            }

            @Override
            public void writeError(Messager messager) {
                for (Unverified m : maybes) {
                    m.writeError(messager);
                }
            }
        };
    }

    public static Unverified<?> combineDifferent(final Unverified<?> ... maybes) {
        return new AbstractVerified<Object>(){

            @Override
            public Object get() {
                return null;
            }

            @Override
            public boolean isVerified() {
                boolean verified = true;
                for (Unverified m : maybes) {
                    verified = verified && m.isVerified();
                }
                return verified;
            }

            @Override
            public void writeError(Messager messager) {
                for (Unverified m : maybes) {
                    m.writeError(messager);
                }
            }
        };
    }
}

