/*
 * Decompiled with CFR 0.152.
 */
package eu.toolchain.serializer.processor.value;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Ordering;
import eu.toolchain.serializer.processor.AutoSerializeUtils;
import eu.toolchain.serializer.processor.annotation.AutoSerializeMirror;
import eu.toolchain.serializer.processor.unverified.Unverified;
import eu.toolchain.serializer.processor.value.Value;
import eu.toolchain.serializer.processor.value.ValueSetBuilder;
import eu.toolchain.serializer.processor.value.ValueSpecification;
import eu.toolchain.serializer.processor.value.ValueType;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;

public class ValueSet {
    static final Ordering<Optional<Integer>> integerOrdering = Ordering.from((Comparator)new Comparator<Optional<Integer>>(){

        @Override
        public int compare(Optional<Integer> a, Optional<Integer> b) {
            if (a.isPresent() && !b.isPresent()) {
                return -1;
            }
            if (!a.isPresent() && b.isPresent()) {
                return 1;
            }
            if (!a.isPresent() && !b.isPresent()) {
                return 0;
            }
            return Integer.compare(a.get(), b.get());
        }
    });
    static final Ordering<Value> orderingById = integerOrdering.onResultOf(f -> f.getId());
    static final Ordering<Value> orderingByCtorOrder = integerOrdering.onResultOf(f -> f.getConstructorOrder());
    static final Ordering<ValueType> orderingTypesById = integerOrdering.onResultOf(f -> f.getId());
    private final boolean orderById;
    private final boolean orderConstructorById;
    private final List<ValueType> types;
    private final List<Value> values;

    public ValueSet(boolean orderById, boolean orderConstructorById) {
        this(orderById, orderConstructorById, (List<ValueType>)ImmutableList.of(), (List<Value>)ImmutableList.of());
    }

    public static Unverified<ValueSet> build(AutoSerializeUtils utils, TypeElement element, Set<ElementKind> kinds, AutoSerializeMirror autoSerialize) {
        ValueSetBuilder valueSet = new ValueSetBuilder(utils);
        for (Unverified<ValueSpecification> value : ValueSet.parseValues(utils, element, kinds, autoSerialize.isUseGetter())) {
            valueSet.add(value);
        }
        return valueSet.build(autoSerialize.isOrderById(), autoSerialize.isOrderConstructorById());
    }

    static Iterable<Unverified<ValueSpecification>> parseValues(AutoSerializeUtils utils, TypeElement enclosing, Set<ElementKind> kinds, boolean defaultUseGetter) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Element element : enclosing.getEnclosedElements()) {
            ExecutableElement e;
            if (!kinds.contains((Object)element.getKind()) || element.getModifiers().contains((Object)Modifier.STATIC) || element instanceof VariableElement && ((VariableElement)element).getConstantValue() != null || utils.ignore(element).isPresent() || element instanceof ExecutableElement && !(e = (ExecutableElement)element).getModifiers().contains((Object)Modifier.ABSTRACT)) continue;
            builder.add(ValueSpecification.build(utils, enclosing, element, defaultUseGetter));
        }
        return builder.build();
    }

    public Iterable<ValueType> getOrderedTypes() {
        if (this.orderById) {
            return orderingTypesById.sortedCopy(this.types);
        }
        return this.types;
    }

    public Iterable<Value> getOrderedValues() {
        if (this.orderById) {
            return orderingById.sortedCopy(this.values);
        }
        return this.values;
    }

    public Iterable<String> getConstructorVariables() {
        Ordering ordering = this.orderById ? orderingByCtorOrder.compound(orderingById) : orderingByCtorOrder;
        return ImmutableList.copyOf((Collection)ordering.sortedCopy(this.values).stream().map(f -> f.getVariableName()).collect(Collectors.toList()));
    }

    public boolean isOrderById() {
        return this.orderById;
    }

    public boolean isOrderConstructorById() {
        return this.orderConstructorById;
    }

    public List<ValueType> getTypes() {
        return this.types;
    }

    public List<Value> getValues() {
        return this.values;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ValueSet)) {
            return false;
        }
        ValueSet other = (ValueSet)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isOrderById() != other.isOrderById()) {
            return false;
        }
        if (this.isOrderConstructorById() != other.isOrderConstructorById()) {
            return false;
        }
        List<ValueType> this$types = this.getTypes();
        List<ValueType> other$types = other.getTypes();
        if (this$types == null ? other$types != null : !((Object)this$types).equals(other$types)) {
            return false;
        }
        List<Value> this$values = this.getValues();
        List<Value> other$values = other.getValues();
        return !(this$values == null ? other$values != null : !((Object)this$values).equals(other$values));
    }

    public boolean canEqual(Object other) {
        return other instanceof ValueSet;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isOrderById() ? 79 : 97);
        result = result * 59 + (this.isOrderConstructorById() ? 79 : 97);
        List<ValueType> $types = this.getTypes();
        result = result * 59 + ($types == null ? 0 : ((Object)$types).hashCode());
        List<Value> $values = this.getValues();
        result = result * 59 + ($values == null ? 0 : ((Object)$values).hashCode());
        return result;
    }

    public String toString() {
        return "ValueSet(orderById=" + this.isOrderById() + ", orderConstructorById=" + this.isOrderConstructorById() + ", types=" + this.getTypes() + ", values=" + this.getValues() + ")";
    }

    @ConstructorProperties(value={"orderById", "orderConstructorById", "types", "values"})
    public ValueSet(boolean orderById, boolean orderConstructorById, List<ValueType> types, List<Value> values) {
        this.orderById = orderById;
        this.orderConstructorById = orderConstructorById;
        this.types = types;
        this.values = values;
    }
}

