/*
 * Decompiled with CFR 0.152.
 */
package fnal.vox.security;

import fnal.vox.log.Log;
import fnal.vox.security.ReadWriteSocket;
import java.io.InputStream;
import java.net.Socket;
import java.security.cert.X509Certificate;
import org.globus.gsi.GSIConstants;
import org.globus.gsi.GlobusCredential;
import org.globus.gsi.GlobusCredentialException;
import org.globus.gsi.TrustedCertificates;
import org.globus.gsi.gssapi.GSSConstants;
import org.globus.gsi.gssapi.GlobusGSSCredentialImpl;
import org.globus.gsi.gssapi.GlobusGSSManagerImpl;
import org.globus.gsi.gssapi.auth.Authorization;
import org.globus.gsi.gssapi.auth.NoAuthorization;
import org.globus.gsi.gssapi.net.GssSocket;
import org.globus.gsi.gssapi.net.GssSocketFactory;
import org.gridforum.jgss.ExtendedGSSContext;
import org.gridforum.jgss.ExtendedGSSManager;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

public abstract class ANAM {
    protected String[] dn = null;
    protected String[] ca = null;
    protected String prin = null;
    protected int lifeTime = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean gsiAuthenticate(Socket socket, ExtendedGSSContext extendedGSSContext) throws Exception {
        byte[] byArray = null;
        byte[] byArray2 = null;
        boolean bl = false;
        InputStream inputStream = null;
        try {
            inputStream = socket.getInputStream();
            ReadWriteSocket readWriteSocket = new ReadWriteSocket(socket);
            while (!extendedGSSContext.isEstablished()) {
                byArray = readWriteSocket.readToken();
                byArray2 = extendedGSSContext.acceptSecContext(byArray, 0, byArray.length);
                if (byArray2 == null) continue;
                readWriteSocket.writeToken(byArray2);
            }
            Log.write((String)"Context established.");
            X509Certificate[] x509CertificateArray = (X509Certificate[])extendedGSSContext.inquireByOid(GSSConstants.X509_CERT_CHAIN);
            if (x509CertificateArray != null) {
                int n = x509CertificateArray.length;
                this.dn = new String[n];
                this.ca = new String[n];
                for (int i = 0; i < n; ++i) {
                    if (x509CertificateArray[i] == null) continue;
                    this.dn[i] = x509CertificateArray[i].getSubjectDN().getName();
                    this.ca[i] = x509CertificateArray[i].getIssuerDN().getName();
                    Log.write((String)("Initiator DN[" + i + "]-->" + this.dn[i]));
                    Log.write((String)("Initiator CA[" + i + "]-->" + this.ca[i]));
                }
            }
            this.lifeTime = extendedGSSContext.getLifetime();
            Log.write((String)("Acceptor  : " + extendedGSSContext.getTargName()));
            Log.write((String)("Lifetime  : " + this.lifeTime));
            Log.write((String)("Privacy   : " + extendedGSSContext.getConfState()));
            GlobusGSSCredentialImpl globusGSSCredentialImpl = (GlobusGSSCredentialImpl)extendedGSSContext.getDelegCred();
            Log.write((String)"Delegated credential :");
            if (globusGSSCredentialImpl != null) {
                Log.write((String)globusGSSCredentialImpl.getGlobusCredential().toString());
            } else {
                Log.write((String)"None");
            }
            bl = true;
        }
        finally {
            try {
                extendedGSSContext.dispose();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return bl;
    }

    public abstract boolean authorize();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sendGsiRequest(Socket socket, ExtendedGSSContext extendedGSSContext) throws Exception {
        InputStream inputStream = null;
        byte[] byArray = null;
        byte[] byArray2 = null;
        try {
            inputStream = socket.getInputStream();
            ReadWriteSocket readWriteSocket = new ReadWriteSocket(socket);
            byArray = new byte[]{};
            byArray2 = null;
            while (!extendedGSSContext.isEstablished()) {
                byArray2 = extendedGSSContext.initSecContext(byArray, 0, byArray.length);
                if (byArray2 != null) {
                    readWriteSocket.writeToken(byArray2);
                }
                if (extendedGSSContext.isEstablished()) continue;
                byArray = readWriteSocket.readToken();
            }
            boolean bl = true;
            return bl;
        }
        finally {
            try {
                extendedGSSContext.dispose();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExtendedGSSContext getGsiServerContext(String string, String string2) throws GSSException {
        GlobusCredential globusCredential = null;
        TrustedCertificates trustedCertificates = null;
        ExtendedGSSContext extendedGSSContext = null;
        if (string == null) {
            string = "/etc/grid-security/hostcert.pem";
        }
        if (string2 == null) {
            string2 = "/etc/grid-security/hostkey.pem";
        }
        if (string.length() == 0) {
            string = "/etc/grid-security/hostcert.pem";
        }
        if (string2.length() == 0) {
            string2 = "/etc/grid-security/hostkey.pem";
        }
        try {
            globusCredential = new GlobusCredential(string, string2);
            globusCredential.verify();
        }
        catch (GlobusCredentialException globusCredentialException) {
            System.out.println((Object)globusCredentialException);
            Log.write((String)globusCredentialException.getMessage());
            throw new GSSException(13, 0, "could not load host globus credentials " + globusCredentialException.toString());
        }
        try {
            GlobusGSSCredentialImpl globusGSSCredentialImpl = new GlobusGSSCredentialImpl(globusCredential, 0);
            trustedCertificates = TrustedCertificates.load((String)"/etc/grid-security/certificates");
            GSSManager gSSManager = ExtendedGSSManager.getInstance();
            extendedGSSContext = (ExtendedGSSContext)gSSManager.createContext((GSSCredential)globusGSSCredentialImpl);
            extendedGSSContext.setOption(GSSConstants.GSS_MODE, (Object)GSIConstants.MODE_GSI);
            extendedGSSContext.setOption(GSSConstants.TRUSTED_CERTIFICATES, (Object)trustedCertificates);
            ExtendedGSSContext extendedGSSContext2 = extendedGSSContext;
            return extendedGSSContext2;
        }
        finally {
            try {
                extendedGSSContext.dispose();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public ExtendedGSSContext getGsiClientContext() throws GSSException {
        GlobusGSSManagerImpl globusGSSManagerImpl = new GlobusGSSManagerImpl();
        ExtendedGSSContext extendedGSSContext = (ExtendedGSSContext)globusGSSManagerImpl.createContext(null, GSSConstants.MECH_OID, null, 0);
        extendedGSSContext.setOption(GSSConstants.GSS_MODE, (Object)GSIConstants.MODE_GSI);
        extendedGSSContext.requestCredDeleg(false);
        return extendedGSSContext;
    }

    public GSSContext getKerberosClientContext(String string) throws GSSException {
        Oid oid = new Oid("1.2.840.113554.1.2.2");
        GSSManager gSSManager = GSSManager.getInstance();
        GSSName gSSName = gSSManager.createName("host/" + string, null);
        GSSContext gSSContext = gSSManager.createContext(gSSName, oid, null, 0);
        return gSSContext;
    }

    public GSSContext getKerberosServerContext() throws Exception {
        Oid oid = new Oid("1.2.840.113554.1.2.2");
        GSSManager gSSManager = GSSManager.getInstance();
        GSSContext gSSContext = gSSManager.createContext((GSSCredential)null);
        return gSSContext;
    }

    public boolean kerberosAuthenticate(Socket socket, GSSContext gSSContext) throws Exception {
        ReadWriteSocket readWriteSocket = new ReadWriteSocket(socket);
        byte[] byArray = null;
        while (!gSSContext.isEstablished()) {
            byArray = readWriteSocket.readKerberosToken();
            if ((byArray = gSSContext.acceptSecContext(byArray, 0, byArray.length)) == null) continue;
            readWriteSocket.writeKerberosToken(byArray);
        }
        this.prin = ((Object)gSSContext.getSrcName()).toString();
        Log.write((String)("Client is " + this.prin));
        Log.write((String)("Server is " + gSSContext.getTargName()));
        return true;
    }

    public boolean sendKerberosRequest(Socket socket, GSSContext gSSContext) throws Exception {
        ReadWriteSocket readWriteSocket = new ReadWriteSocket(socket);
        gSSContext.requestMutualAuth(true);
        gSSContext.requestConf(true);
        gSSContext.requestInteg(true);
        byte[] byArray = new byte[1];
        while (!gSSContext.isEstablished()) {
            if ((byArray = gSSContext.initSecContext(byArray, 0, byArray.length)) != null) {
                readWriteSocket.writeKerberosToken(byArray);
            }
            if (gSSContext.isEstablished()) continue;
            byArray = readWriteSocket.readKerberosToken();
        }
        return true;
    }

    public Socket getGsiServerSocket(Socket socket, ExtendedGSSContext extendedGSSContext) throws Exception {
        socket = GssSocketFactory.getDefault().createSocket(socket, null, 0, (GSSContext)extendedGSSContext);
        ((GssSocket)socket).setUseClientMode(false);
        ((GssSocket)socket).setWrapMode(2);
        ((GssSocket)socket).setAuthorization((Authorization)NoAuthorization.getInstance());
        return socket;
    }

    public Socket getGsiClientSocket(String string, int n, ExtendedGSSContext extendedGSSContext) throws Exception {
        Socket socket = GssSocketFactory.getDefault().createSocket(string, n, (GSSContext)extendedGSSContext);
        ((GssSocket)socket).setWrapMode(2);
        ((GssSocket)socket).setAuthorization((Authorization)NoAuthorization.getInstance());
        return socket;
    }
}

