/*
 * Decompiled with CFR 0.152.
 */
package fnal.vox.security;

import fnal.vox.log.Log;
import fnal.vox.security.CA;
import fnal.vox.security.CertInputStream;
import fnal.vox.security.CrlFilter;
import fnal.vox.security.Http;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.StringTokenizer;
import org.globus.gsi.CertificateRevocationLists;
import org.globus.gsi.TrustedCertificates;
import org.globus.gsi.proxy.ProxyPathValidator;

public class ANAMUtil {
    private CA[] cA;
    private TrustedCertificates trustedCerts;
    private CertificateRevocationLists crls;

    private void loadTrustedCertificates(String string) {
        this.trustedCerts = TrustedCertificates.load((String)string);
    }

    private void loadCrls(String string) {
        this.crls = CertificateRevocationLists.getCertificateRevocationLists((String)string);
        System.out.println("Total number of crls " + this.crls.getCrls().length);
        X509CRL[] x509CRLArray = this.crls.getCrls();
        for (int i = 0; i < x509CRLArray.length; ++i) {
            System.out.println("Issuer is " + x509CRLArray[i].getIssuerDN().getName());
        }
    }

    public void verifyChain(X509Certificate[] x509CertificateArray) throws Exception {
        ProxyPathValidator proxyPathValidator = new ProxyPathValidator();
        proxyPathValidator.validate(x509CertificateArray, this.trustedCerts.getCertificates());
    }

    public boolean isRevoked(X509Certificate x509Certificate) {
        boolean bl = false;
        String string = x509Certificate.getIssuerDN().getName();
        String string2 = x509Certificate.getSubjectDN().getName();
        for (int i = 0; i < this.cA.length; ++i) {
            String string3;
            if (this.cA[i].x509Crl == null || !this.matchDN(string, string3 = this.cA[i].x509Crl.getIssuerDN().getName())) continue;
            bl = this.cA[i].x509Crl.isRevoked(x509Certificate);
            return bl;
        }
        return true;
    }

    public boolean isNotSigned(X509Certificate x509Certificate) {
        System.out.println("checking signning policy");
        boolean bl = false;
        String string = x509Certificate.getIssuerDN().getName();
        String string2 = x509Certificate.getSubjectDN().getName();
        for (int i = 0; i < this.cA.length; ++i) {
            String string3;
            if (this.cA[i].x509Crl == null || !this.matchDN(string, string3 = this.cA[i].x509Crl.getIssuerDN().getName())) continue;
            String[] stringArray = this.cA[i].policy;
            for (int j = 0; j < stringArray.length; ++j) {
                System.out.println("\n\ntrying ..\ncertIssuerDN--->" + string + "\npolicy[j]--->" + stringArray[j] + "\nuserDN--->" + string2);
                bl = this.matchWildCardDN(string2, stringArray[j]);
                if (!bl) continue;
                System.out.println("returnning false ");
                System.out.println("policy[j]--->" + stringArray[j] + "\nuserDN--->" + string2);
                return false;
            }
            return true;
        }
        return true;
    }

    public void initCA(String string) {
        File file = new File(string);
        CrlFilter crlFilter = new CrlFilter();
        String[] stringArray = file.list(crlFilter);
        X509CRL[] x509CRLArray = new X509CRL[stringArray.length];
        CA[] cAArray = new CA[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                RandomAccessFile randomAccessFile = new RandomAccessFile(string + "/" + stringArray[i], "r");
                String string2 = randomAccessFile.readLine();
                randomAccessFile.close();
                x509CRLArray[i] = this.initOneCrl(string2);
                String string3 = stringArray[i].replaceAll("crl_url", "signing_policy");
                cAArray[i] = new CA(x509CRLArray[i], this.initOnePolicy(string3, string));
                continue;
            }
            catch (Exception exception) {
                System.out.println(exception.getMessage());
            }
        }
        this.cA = cAArray;
        this.loadTrustedCertificates(string);
    }

    private boolean matchWildCardDN(String string, String string2) {
        int n;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",/");
        StringTokenizer stringTokenizer2 = new StringTokenizer(string2, ",/");
        int n2 = stringTokenizer.countTokens();
        int n3 = stringTokenizer2.countTokens();
        int n4 = 0;
        String[] stringArray = new String[n2];
        String[] stringArray2 = new String[n3];
        for (n = 0; n < n2; ++n) {
            stringArray[n] = stringTokenizer.nextToken().trim();
        }
        for (n = 0; n < n3; ++n) {
            String string3 = stringTokenizer2.nextToken().trim();
            if (string3.equals("*") || string3.equals("")) continue;
            stringArray2[n] = string3;
            ++n4;
        }
        for (n = 0; n < n4; ++n) {
            if (this.isPresent(stringArray, stringArray2[n])) continue;
            return false;
        }
        return true;
    }

    private boolean matchDN(String string, String string2) {
        int n;
        int n2;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",/");
        StringTokenizer stringTokenizer2 = new StringTokenizer(string2, ",/");
        int n3 = stringTokenizer.countTokens();
        if (n3 != (n2 = stringTokenizer2.countTokens())) {
            return false;
        }
        String[] stringArray = new String[n3];
        String[] stringArray2 = new String[n2];
        for (n = 0; n < n3; ++n) {
            stringArray[n] = stringTokenizer.nextToken().trim();
            stringArray2[n] = stringTokenizer2.nextToken().trim();
        }
        for (n = 0; n < n3; ++n) {
            if (this.isPresent(stringArray2, stringArray[n])) continue;
            return false;
        }
        return true;
    }

    private boolean isPresent(String[] stringArray, String string) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.equals(stringArray[i])) continue;
            return true;
        }
        return false;
    }

    private X509CRL initOneCrl(String string) {
        X509CRL x509CRL = null;
        try {
            String string2;
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            Http http = new Http(string);
            InputStream inputStream = http.getInputStream();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            boolean bl = false;
            String string3 = "";
            while ((string2 = bufferedReader.readLine()) != null) {
                if (string2.equals("-----BEGIN X509 CRL-----")) {
                    bl = true;
                }
                if (!bl) continue;
                string3 = string3 + string2 + "\n";
            }
            if (string3.length() > 0) {
                CertInputStream certInputStream = new CertInputStream(string3);
                x509CRL = (X509CRL)certificateFactory.generateCRL(certInputStream);
                certInputStream.close();
            }
            inputStream.close();
        }
        catch (Exception exception) {
            Log.write((String)exception.getMessage());
        }
        return x509CRL;
    }

    public String getOneCert(String string) {
        String string2 = "";
        try {
            String string3;
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            RandomAccessFile randomAccessFile = new RandomAccessFile(string, "r");
            boolean bl = false;
            while ((string3 = randomAccessFile.readLine()) != null) {
                if (string3.equals("-----BEGIN CERTIFICATE-----")) {
                    bl = true;
                }
                if (bl) {
                    string2 = string2 + string3 + "\n";
                }
                if (!string3.equals("-----END CERTIFICATE-----")) continue;
            }
            randomAccessFile.close();
        }
        catch (Exception exception) {
            Log.write((String)exception.getMessage());
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] initOnePolicy(String string, String string2) {
        String[] stringArray = new String[1];
        RandomAccessFile randomAccessFile = null;
        try {
            String string3;
            stringArray[0] = "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx";
            randomAccessFile = new RandomAccessFile(string2 + "/" + string, "r");
            while ((string3 = randomAccessFile.readLine()) != null) {
                Object object;
                int n;
                if (!(string3 = string3.trim()).startsWith("cond_subjects")) continue;
                Log.write((String)("Signning policy subjects " + string3));
                StringTokenizer stringTokenizer = new StringTokenizer(string3, "'");
                int n2 = stringTokenizer.countTokens();
                if (n2 != 2) {
                    String[] stringArray2 = stringArray;
                    return stringArray2;
                }
                stringTokenizer.nextToken();
                n2 = 0;
                String string4 = stringTokenizer.nextToken();
                stringTokenizer = new StringTokenizer(string4, "\"");
                int n3 = stringTokenizer.countTokens();
                for (n = 0; n < n3; ++n) {
                    object = stringTokenizer.nextToken();
                    if (((String)(object = ((String)object).trim())).length() <= 0) continue;
                    ++n2;
                }
                stringArray = new String[n2];
                n2 = 0;
                stringTokenizer = new StringTokenizer(string4, "\"");
                n3 = stringTokenizer.countTokens();
                for (n = 0; n < n3; ++n) {
                    object = stringTokenizer.nextToken();
                    if (((String)(object = ((String)object).trim())).length() <= 0) continue;
                    stringArray[n2] = object;
                    ++n2;
                }
                object = stringArray;
                return object;
            }
        }
        catch (Exception exception) {
            Log.write((String)exception.getMessage());
        }
        finally {
            try {
                randomAccessFile.close();
            }
            catch (Exception exception) {
                Log.write((String)exception.getMessage());
            }
        }
        return stringArray;
    }
}

