/*
 * Decompiled with CFR 0.152.
 */
package fnal.vox.security;

import com.sun.security.auth.callback.TextCallbackHandler;
import fnal.vox.security.MyAction;
import java.security.PrivilegedActionException;
import javax.security.auth.Subject;
import javax.security.auth.login.AccountExpiredException;
import javax.security.auth.login.CredentialExpiredException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;

public class Login {
    public static void main(String[] stringArray) {
        int n;
        LoginContext loginContext = null;
        try {
            loginContext = new LoginContext(stringArray[0], new TextCallbackHandler());
        }
        catch (LoginException loginException) {
            System.err.println("Cannot create LoginContext. " + loginException.getMessage());
            System.exit(-1);
        }
        catch (SecurityException securityException) {
            System.err.println("Cannot create LoginContext. " + securityException.getMessage());
            System.exit(-1);
        }
        for (n = 0; n < 3; ++n) {
            try {
                loginContext.login();
                break;
            }
            catch (AccountExpiredException accountExpiredException) {
                System.err.println("Your account has expired.  Please notify your administrator.");
                System.exit(-1);
                continue;
            }
            catch (CredentialExpiredException credentialExpiredException) {
                System.err.println("Your credentials have expired.");
                System.exit(-1);
                continue;
            }
            catch (FailedLoginException failedLoginException) {
                System.err.println("Authentication Failed");
                try {
                    Thread.currentThread();
                    Thread.sleep(3000L);
                }
                catch (Exception exception) {}
                continue;
            }
            catch (Exception exception) {
                System.err.println("Unexpected Exception - unable to continue");
                exception.printStackTrace();
                System.exit(-1);
            }
        }
        if (n == 3) {
            System.err.println("Sorry");
            System.exit(-1);
        }
        Subject subject = loginContext.getSubject();
        try {
            Subject.doAs(subject, new MyAction(stringArray));
        }
        catch (PrivilegedActionException privilegedActionException) {
            privilegedActionException.printStackTrace();
            System.exit(-1);
        }
    }
}

