/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.snippets;

import guru.nidi.snippets.Snippets;
import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="snippets", defaultPhase=LifecyclePhase.GENERATE_RESOURCES)
public class SnippetsMojo
extends AbstractMojo {
    @Parameter(property="snippets.snippetStart", defaultValue="//## %name")
    private String snippetStart;
    @Parameter(property="snippets.snippetEnd", defaultValue="//##")
    private String snippetEnd;
    @Parameter(property="snippets.refStart", defaultValue="[//]: # (%name)")
    private String refStart;
    @Parameter(property="snippets.refEnd", defaultValue="[//]: # (end)")
    private String refEnd;
    @Parameter(property="snippets.prefix", defaultValue="")
    private String prefix;
    @Parameter(property="snippets.postfix", defaultValue="")
    private String postfix;
    @Parameter(property="snippets.inputs", required=true)
    private File[] inputs;
    @Parameter(property="snippets.outputs", required=true)
    private File[] outputs;
    @Parameter(property="snippets.encoding", defaultValue="UTF-8")
    private String encoding;
    @Parameter(property="snippets.replace", defaultValue="true")
    private boolean replace;
    @Parameter(property="snippets.target.dir", defaultValue="target")
    private File target;
    @Parameter(property="snippets.target.extension", defaultValue="out")
    private String extension;
    @Parameter(property="snippets.tab.size", defaultValue="4")
    private int tabSize;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.inputs.length == 0) {
            throw new MojoFailureException("Missing parameter 'inputs'");
        }
        if (this.outputs.length == 0) {
            throw new MojoFailureException("Missing parameter 'outputs'");
        }
        try {
            Snippets snippets = this.readInputs(new Snippets(this.snippetStart, this.snippetEnd, this.refStart, this.refEnd, this.tabSize).prefix(this.unescape(this.prefix)).postfix(this.unescape(this.postfix)));
            this.getLog().info((CharSequence)("Found " + snippets.size() + " snippets."));
            this.createOutputs(snippets);
        }
        catch (IOException e) {
            throw new MojoFailureException("Could not replace snippets.", (Throwable)e);
        }
    }

    private String unescape(String s) {
        return s.replaceAll("\\\\n", "\n").replaceAll("\\\\r", "\r").replaceAll("\\\\t", "\t");
    }

    private Snippets readInputs(Snippets snippets) throws IOException {
        for (File input : this.inputs) {
            if (input.isDirectory()) {
                for (File in : input.listFiles()) {
                    snippets = this.doRead(snippets, in);
                }
                continue;
            }
            snippets = this.doRead(snippets, input);
        }
        return snippets;
    }

    private Snippets doRead(Snippets snippets, File file) throws IOException {
        this.getLog().info((CharSequence)("Reading " + file));
        return snippets.withFile(file, this.encoding);
    }

    private void createOutputs(Snippets snippets) throws IOException {
        for (File output : this.outputs) {
            if (output.isDirectory()) {
                for (File out : output.listFiles()) {
                    this.doReplace(snippets, out);
                }
                continue;
            }
            this.doReplace(snippets, output);
        }
    }

    private void doReplace(Snippets snippets, File output) throws IOException {
        this.getLog().info((CharSequence)("Replacing " + output.getName()));
        if (this.replace) {
            snippets.replaceSnippets(output, this.encoding);
        } else {
            snippets.replaceRefs(output, this.outputFor(output), this.encoding);
        }
    }

    private File outputFor(File file) {
        String name = file.getName();
        int pos = name.lastIndexOf(46);
        return new File(this.target, name.substring(0, pos + 1) + this.extension);
    }
}

