/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.xstream.converters.enums;

import cucumber.runtime.xstream.converters.Converter;
import cucumber.runtime.xstream.converters.MarshallingContext;
import cucumber.runtime.xstream.converters.UnmarshallingContext;
import cucumber.runtime.xstream.io.HierarchicalStreamReader;
import cucumber.runtime.xstream.io.HierarchicalStreamWriter;

public class EnumConverter
implements Converter {
    public boolean canConvert(Class type) {
        return type.isEnum() || Enum.class.isAssignableFrom(type);
    }

    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        writer.setValue(((Enum)source).name());
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        Class type = context.getRequiredType();
        if (type.getSuperclass() != Enum.class) {
            type = type.getSuperclass();
        }
        return Enum.valueOf(type, reader.getValue());
    }
}

