/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.xstream.converters.extended;

import cucumber.runtime.xstream.converters.Converter;
import cucumber.runtime.xstream.converters.MarshallingContext;
import cucumber.runtime.xstream.converters.UnmarshallingContext;
import cucumber.runtime.xstream.io.HierarchicalStreamReader;
import cucumber.runtime.xstream.io.HierarchicalStreamWriter;
import java.awt.Font;
import java.awt.font.TextAttribute;
import java.util.Map;
import javax.swing.plaf.FontUIResource;

public class FontConverter
implements Converter {
    public boolean canConvert(Class type) {
        return type.getName().equals("java.awt.Font") || type.getName().equals("javax.swing.plaf.FontUIResource");
    }

    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        Font font = (Font)source;
        Map<TextAttribute, ?> attributes = font.getAttributes();
        writer.startNode("attributes");
        context.convertAnother(attributes);
        writer.endNode();
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        reader.moveDown();
        Map attributes = (Map)context.convertAnother(null, Map.class);
        reader.moveUp();
        Font font = Font.getFont(attributes);
        if (context.getRequiredType() == FontUIResource.class) {
            return new FontUIResource(font);
        }
        return font;
    }
}

