/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.xstream.io.xml;

import cucumber.runtime.xstream.converters.ErrorWriter;
import cucumber.runtime.xstream.core.util.FastStack;
import cucumber.runtime.xstream.io.AttributeNameIterator;
import cucumber.runtime.xstream.io.naming.NameCoder;
import cucumber.runtime.xstream.io.xml.AbstractXmlReader;
import cucumber.runtime.xstream.io.xml.DocumentReader;
import cucumber.runtime.xstream.io.xml.XmlFriendlyNameCoder;
import cucumber.runtime.xstream.io.xml.XmlFriendlyReplacer;
import java.util.Iterator;

public abstract class AbstractDocumentReader
extends AbstractXmlReader
implements DocumentReader {
    private FastStack pointers = new FastStack(16);
    private Object current;

    protected AbstractDocumentReader(Object rootElement) {
        this(rootElement, new XmlFriendlyNameCoder());
    }

    protected AbstractDocumentReader(Object rootElement, NameCoder nameCoder) {
        super(nameCoder);
        this.current = rootElement;
        this.pointers.push(new Pointer());
        this.reassignCurrentElement(this.current);
    }

    protected AbstractDocumentReader(Object rootElement, XmlFriendlyReplacer replacer) {
        this(rootElement, (NameCoder)replacer);
    }

    protected abstract void reassignCurrentElement(Object var1);

    protected abstract Object getParent();

    protected abstract Object getChild(int var1);

    protected abstract int getChildCount();

    public boolean hasMoreChildren() {
        Pointer pointer = (Pointer)this.pointers.peek();
        return pointer.v < this.getChildCount();
    }

    public void moveUp() {
        this.current = this.getParent();
        this.pointers.popSilently();
        this.reassignCurrentElement(this.current);
    }

    public void moveDown() {
        Pointer pointer = (Pointer)this.pointers.peek();
        this.pointers.push(new Pointer());
        this.current = this.getChild(pointer.v);
        ++pointer.v;
        this.reassignCurrentElement(this.current);
    }

    public Iterator getAttributeNames() {
        return new AttributeNameIterator(this);
    }

    public void appendErrors(ErrorWriter errorWriter) {
    }

    public Object getCurrent() {
        return this.current;
    }

    public void close() {
    }

    private static class Pointer {
        public int v;

        private Pointer() {
        }
    }
}

