/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime;

import cucumber.formatter.ColorAware;
import cucumber.formatter.FormatterConverter;
import cucumber.formatter.ProgressFormatter;
import cucumber.io.ResourceLoader;
import cucumber.runtime.model.CucumberFeature;
import gherkin.formatter.Formatter;
import gherkin.formatter.Reporter;
import gherkin.util.FixJava;
import java.io.File;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;

public class RuntimeOptions {
    public static final String VERSION = ResourceBundle.getBundle("cucumber.version").getString("cucumber-jvm.version");
    public static final String USAGE = FixJava.readResource((String)"/cucumber/runtime/USAGE.txt");
    public List<String> glue = new ArrayList<String>();
    public File dotCucumber;
    public boolean dryRun;
    public List<String> tags = new ArrayList<String>();
    public List<Formatter> formatters = new ArrayList<Formatter>();
    public List<String> featurePaths = new ArrayList<String>();
    private boolean monochrome = false;

    public RuntimeOptions(String ... argv) {
        this.parse(new ArrayList<String>(Arrays.asList(argv)));
        if (this.formatters.isEmpty()) {
            this.formatters.add(new ProgressFormatter(System.out));
        }
        for (Formatter formatter : this.formatters) {
            if (!(formatter instanceof ColorAware)) continue;
            ColorAware colorAware = (ColorAware)formatter;
            colorAware.setMonochrome(this.monochrome);
        }
    }

    private void parse(ArrayList<String> args) {
        FormatterConverter formatterConverter = new FormatterConverter();
        while (!args.isEmpty()) {
            String arg = args.remove(0);
            if (arg.equals("--help") || arg.equals("-h")) {
                System.out.println(USAGE);
                System.exit(0);
                continue;
            }
            if (arg.equals("--version") || arg.equals("-v")) {
                System.out.println(VERSION);
                System.exit(0);
                continue;
            }
            if (arg.equals("--glue") || arg.equals("-g")) {
                String gluePath = args.remove(0);
                this.glue.add(gluePath);
                continue;
            }
            if (arg.equals("--tags") || arg.equals("-t")) {
                this.tags.add(args.remove(0));
                continue;
            }
            if (arg.equals("--format") || arg.equals("-f")) {
                this.formatters.add(formatterConverter.convert(args.remove(0)));
                continue;
            }
            if (arg.equals("--dotcucumber")) {
                this.dotCucumber = new File(args.remove(0));
                continue;
            }
            if (arg.equals("--dry-run") || arg.equals("-d")) {
                this.dryRun = true;
                continue;
            }
            if (arg.equals("--monochrome") || arg.equals("-m")) {
                this.monochrome = true;
                continue;
            }
            this.featurePaths.add(arg);
        }
    }

    public List<CucumberFeature> cucumberFeatures(ResourceLoader resourceLoader) {
        return CucumberFeature.load(resourceLoader, this.featurePaths, this.filters());
    }

    public Formatter formatter(ClassLoader classLoader) {
        return (Formatter)Proxy.newProxyInstance(classLoader, new Class[]{Formatter.class}, new InvocationHandler(){

            @Override
            public Object invoke(Object target, Method method, Object[] args) throws Throwable {
                for (Formatter formatter : RuntimeOptions.this.formatters) {
                    method.invoke((Object)formatter, args);
                }
                return null;
            }
        });
    }

    public Reporter reporter(ClassLoader classLoader) {
        return (Reporter)Proxy.newProxyInstance(classLoader, new Class[]{Reporter.class}, new InvocationHandler(){

            @Override
            public Object invoke(Object target, Method method, Object[] args) throws Throwable {
                for (Formatter formatter : RuntimeOptions.this.formatters) {
                    if (!(formatter instanceof Reporter)) continue;
                    method.invoke((Object)formatter, args);
                }
                return null;
            }
        });
    }

    private List<Object> filters() {
        ArrayList<Object> filters = new ArrayList<Object>();
        filters.addAll(this.tags);
        return filters;
    }
}

