/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.converters;

import cucumber.runtime.CucumberException;
import cucumber.runtime.ParameterType;
import cucumber.runtime.converters.CalendarConverter;
import cucumber.runtime.converters.ConverterWithFormat;
import cucumber.runtime.converters.DateConverter;
import java.text.DateFormat;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;

public abstract class TimeConverter<T>
extends ConverterWithFormat<T> {
    private static final TimeZone UTC = TimeZone.getTimeZone("UTC");
    protected final Locale locale;
    private final List<DateFormat> formats = new ArrayList<DateFormat>();
    private SimpleDateFormat onlyFormat;

    public TimeConverter(Locale locale, Class[] convertibleTypes) {
        super(convertibleTypes);
        this.locale = locale;
        this.addFormat(3, locale);
        this.addFormat(2, locale);
        this.addFormat(1, locale);
        this.addFormat(0, locale);
    }

    protected void addFormat(int style, Locale locale) {
        this.add(DateFormat.getDateInstance(style, locale));
    }

    protected void add(DateFormat dateFormat) {
        dateFormat.setLenient(false);
        dateFormat.setTimeZone(UTC);
        this.formats.add(dateFormat);
    }

    @Override
    public List<? extends Format> getFormats() {
        return this.onlyFormat == null ? this.formats : Arrays.asList(this.onlyFormat);
    }

    public void setOnlyFormat(String dateFormatString, Locale locale) {
        this.onlyFormat = new SimpleDateFormat(dateFormatString, locale);
        this.onlyFormat.setLenient(false);
        this.onlyFormat.setTimeZone(UTC);
    }

    public void removeOnlyFormat() {
        this.onlyFormat = null;
    }

    public static TimeConverter getInstance(ParameterType parameterType, Locale locale) {
        if (Date.class.isAssignableFrom(parameterType.getParameterClass())) {
            return new DateConverter(locale);
        }
        if (Calendar.class.isAssignableFrom(parameterType.getParameterClass())) {
            return new CalendarConverter(locale);
        }
        throw new CucumberException("Unsupported time type: " + parameterType.getParameterClass());
    }

    public static List<Class> getTimeClasses() {
        ArrayList<Class> classes = new ArrayList<Class>();
        classes.add(Date.class);
        classes.add(Calendar.class);
        return classes;
    }
}

