/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.xstream.converters.collections;

import cucumber.runtime.xstream.converters.UnmarshallingContext;
import cucumber.runtime.xstream.converters.collections.CollectionConverter;
import cucumber.runtime.xstream.io.HierarchicalStreamReader;
import cucumber.runtime.xstream.mapper.Mapper;
import java.util.Collections;

public class SingletonCollectionConverter
extends CollectionConverter {
    private static final Class LIST = Collections.singletonList(Boolean.TRUE).getClass();
    private static final Class SET = Collections.singleton(Boolean.TRUE).getClass();

    public SingletonCollectionConverter(Mapper mapper) {
        super(mapper);
    }

    public boolean canConvert(Class type) {
        return LIST == type || SET == type;
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        reader.moveDown();
        Object item = this.readItem(reader, context, null);
        reader.moveUp();
        return context.getRequiredType() == LIST ? Collections.singletonList(item) : Collections.singleton(item);
    }
}

