/*
 * Decompiled with CFR 0.152.
 */
package cucumber.table.xstream;

import cucumber.table.DataTable;
import cucumber.table.TableConverter;
import cucumber.table.xstream.DataTableWriter;
import gherkin.formatter.model.Comment;
import gherkin.formatter.model.DataTableRow;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ListOfListOfSingleValueWriter
extends DataTableWriter {
    private static final List<Comment> NO_COMMENTS = Collections.emptyList();
    private final List<DataTableRow> rows = new ArrayList<DataTableRow>();
    private final TableConverter tableConverter;
    private int nodeDepth;
    private List<String> cells;

    public ListOfListOfSingleValueWriter(TableConverter tableConverter) {
        this.tableConverter = tableConverter;
    }

    @Override
    public DataTable getDataTable() {
        return new DataTable(this.rows, this.tableConverter);
    }

    @Override
    public void startNode(String name) {
        ++this.nodeDepth;
        if (this.nodeDepth == 2) {
            this.cells = new ArrayList<String>();
        }
    }

    @Override
    public void addAttribute(String name, String value) {
    }

    @Override
    public void setValue(String text) {
        this.cells.add(text);
    }

    @Override
    public void endNode() {
        if (this.nodeDepth == 2) {
            DataTableRow row = new DataTableRow(NO_COMMENTS, this.cells, 0);
            this.rows.add(row);
        }
        --this.nodeDepth;
    }

    @Override
    public void flush() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() {
        throw new UnsupportedOperationException();
    }
}

