/*
 * Decompiled with CFR 0.152.
 */
package cucumber.table.xstream;

import cucumber.table.DataTable;
import cucumber.table.TableConverter;
import cucumber.table.xstream.DataTableWriter;
import gherkin.formatter.model.Comment;
import gherkin.formatter.model.DataTableRow;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ListOfObjectWriter
extends DataTableWriter {
    private static final List<Comment> NO_COMMENTS = Collections.emptyList();
    private final List<DataTableRow> rows = new ArrayList<DataTableRow>();
    private final TableConverter tableConverter;
    private int nodeDepth = 0;
    private List<String> header = new ArrayList<String>();
    private List<String> cells;

    public ListOfObjectWriter(TableConverter tableConverter) {
        this.tableConverter = tableConverter;
    }

    @Override
    public DataTable getDataTable() {
        return new DataTable(this.rows, this.tableConverter);
    }

    @Override
    public void startNode(String name) {
        ++this.nodeDepth;
        if (this.nodeDepth == 2) {
            this.cells = new ArrayList<String>();
        }
        if (this.nodeDepth == 3 && this.header != null) {
            this.header.add(name);
        }
    }

    @Override
    public void addAttribute(String name, String value) {
    }

    @Override
    public void setValue(String text) {
        this.cells.add(text);
    }

    @Override
    public void endNode() {
        if (this.nodeDepth == 2) {
            if (this.header != null) {
                DataTableRow headerRow = new DataTableRow(NO_COMMENTS, this.header, 0);
                this.rows.add(headerRow);
                this.header = null;
            }
            DataTableRow row = new DataTableRow(NO_COMMENTS, this.cells, 0);
            this.rows.add(row);
        }
        --this.nodeDepth;
    }

    @Override
    public void flush() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() {
        throw new UnsupportedOperationException();
    }
}

