/*
 * Decompiled with CFR 0.152.
 */
package io.activej.common;

import io.activej.common.MemSize;
import io.activej.common.exception.MalformedDataException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.Period;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class StringFormatUtils {
    private static final Pattern MEM_SIZE_PATTERN = Pattern.compile("(?<size>\\d+)([.](?<floating>\\d+))?\\s*(?<unit>(|g|m|k|t)b?)?(\\s+|$)", 2);
    private static final Pattern DURATION_PATTERN = Pattern.compile("(?<time>-?\\d+)([.](?<floating>\\d+))?\\s+(?<unit>days?|hours?|minutes?|seconds?|millis?|nanos?)(\\s+|$)");
    private static final int NANOS_IN_MILLI = 1000000;
    private static final int MILLIS_IN_SECOND = 1000;
    private static final int SECONDS_PER_MINUTE = 60;
    private static final int SECONDS_PER_HOUR = 3600;
    private static final int SECONDS_PER_DAY = 86400;
    private static final Pattern PERIOD_PATTERN = Pattern.compile("(?<str>((?<time>-?\\d+)([.](?<floating>\\d+))?\\s+(?<unit>years?|months?|days?))(\\s+|$))");
    private static final DateTimeFormatter DATE_TIME_FORMATTER = new DateTimeFormatterBuilder().parseCaseInsensitive().append(DateTimeFormatter.ISO_LOCAL_DATE).appendLiteral(' ').append(DateTimeFormatter.ISO_LOCAL_TIME).toFormatter();

    public static String formatMemSize(MemSize memSize) {
        return StringFormatUtils.formatBytes(memSize.toLong());
    }

    public static String formatBytes(long bytes) {
        if (bytes == 0L) {
            return "0";
        }
        long unit = 0x10000000000L;
        while (true) {
            long divideResult = bytes / unit;
            long remainder = bytes % unit;
            if (divideResult != 0L && remainder == 0L) {
                return divideResult + StringFormatUtils.getUnit(unit);
            }
            unit /= 1024L;
        }
    }

    public static String formatMemSizeHumanReadable(MemSize memSize) {
        return StringFormatUtils.formatBytesHumanReadable(memSize.toLong());
    }

    public static String formatBytesHumanReadable(long bytes) {
        long unit = 0x10000000000L;
        long divideResult;
        while ((divideResult = bytes / unit) < 10L && unit != 1L) {
            unit /= 1024L;
        }
        return divideResult + StringFormatUtils.getUnit(unit);
    }

    private static String getUnit(long unit) {
        if (unit == 0x10000000000L) {
            return "Tb";
        }
        return switch ((int)unit) {
            case 0x40000000 -> "Gb";
            case 0x100000 -> "Mb";
            case 1024 -> "Kb";
            case 1 -> "";
            default -> throw new IllegalArgumentException("Wrong unit");
        };
    }

    public static MemSize parseMemSize(String string) {
        HashSet<String> units = new HashSet<String>();
        Matcher matcher = MEM_SIZE_PATTERN.matcher(string.trim().toLowerCase());
        long result = 0L;
        int lastEnd = 0;
        while (!matcher.hitEnd()) {
            if (!matcher.find() || matcher.start() != lastEnd) {
                throw new IllegalArgumentException("Invalid MemSize: " + string);
            }
            lastEnd = matcher.end();
            Object unit = matcher.group("unit");
            if (unit == null) {
                unit = "";
            }
            if (!((String)unit).endsWith("b")) {
                unit = (String)unit + "b";
            }
            if (!units.add((String)unit)) {
                throw new IllegalArgumentException("Memory unit " + (String)unit + " occurs more than once in: " + string);
            }
            long memsize = Long.parseLong(matcher.group("size"));
            long numerator = 0L;
            long denominator = 1L;
            String floatingPoint = matcher.group("floating");
            if (floatingPoint != null) {
                if (((String)unit).equals("b")) {
                    throw new IllegalArgumentException("MemSize unit bytes cannot be fractional");
                }
                numerator = Long.parseLong(floatingPoint);
                for (int i = 0; i < floatingPoint.length(); ++i) {
                    denominator *= 10L;
                }
            }
            double fractional = (double)numerator / (double)denominator;
            switch (unit) {
                case "tb": {
                    result += memsize * 0x10000000000L;
                    result += Math.round(1.099511627776E12 * fractional);
                    break;
                }
                case "gb": {
                    result += memsize * 0x40000000L;
                    result += Math.round(1.073741824E9 * fractional);
                    break;
                }
                case "mb": {
                    result += memsize * 0x100000L;
                    result += Math.round(1048576.0 * fractional);
                    break;
                }
                case "kb": {
                    result += memsize * 1024L;
                    result += Math.round(1024.0 * fractional);
                    break;
                }
                case "b": 
                case "": {
                    result += memsize;
                }
            }
        }
        return MemSize.of(result);
    }

    public static String formatDuration(Duration value) {
        long nano;
        long milli;
        long seconds;
        long minutes;
        long hours;
        if (value.isZero()) {
            return "0 seconds";
        }
        Object result = "";
        long days = value.toDays();
        if (days != 0L) {
            result = (String)result + days + " days ";
        }
        if ((hours = value.toHours() - days * 24L) != 0L) {
            result = (String)result + hours + " hours ";
        }
        if ((minutes = value.toMinutes() - days * 1440L - hours * 60L) != 0L) {
            result = (String)result + minutes + " minutes ";
        }
        if ((seconds = value.getSeconds() - days * 86400L - hours * 3600L - minutes * 60L) != 0L) {
            result = (String)result + seconds + " seconds ";
        }
        if ((milli = ((nano = (long)value.getNano()) - nano % 1000000L) / 1000000L) != 0L) {
            result = (String)result + milli + " millis ";
        }
        if ((nano %= 1000000L) != 0L) {
            result = (String)result + nano + " nanos ";
        }
        return ((String)result).trim();
    }

    public static Duration parseDuration(String string) {
        if ((string = string.trim()).startsWith("-P") || string.startsWith("P")) {
            return Duration.parse(string);
        }
        HashSet<String> units = new HashSet<String>();
        int days = 0;
        int hours = 0;
        int minutes = 0;
        long seconds = 0L;
        long millis = 0L;
        long nanos = 0L;
        double doubleSeconds = 0.0;
        Matcher matcher = DURATION_PATTERN.matcher(string.trim().toLowerCase());
        int lastEnd = 0;
        while (!matcher.hitEnd()) {
            if (!matcher.find() || matcher.start() != lastEnd) {
                throw new IllegalArgumentException("Invalid duration: " + string);
            }
            lastEnd = matcher.end();
            Object unit = matcher.group("unit");
            if (!((String)unit).endsWith("s")) {
                unit = (String)unit + "s";
            }
            if (!units.add((String)unit)) {
                throw new IllegalArgumentException("Time unit " + (String)unit + " occurs more than once in: " + string);
            }
            long result = Long.parseLong(matcher.group("time"));
            int numerator = 0;
            int denominator = 1;
            String floatingPoint = matcher.group("floating");
            if (floatingPoint != null) {
                if (((String)unit).equals("nanos")) {
                    throw new IllegalArgumentException("Time unit nanos cannot be fractional");
                }
                numerator = Integer.parseInt(floatingPoint);
                for (int i = 0; i < floatingPoint.length(); ++i) {
                    denominator *= 10;
                }
            }
            double fractional = (double)numerator / (double)denominator;
            switch (unit) {
                case "days": {
                    days = (int)result;
                    doubleSeconds += 86400.0 * fractional;
                    break;
                }
                case "hours": {
                    hours += (int)result;
                    doubleSeconds += 3600.0 * fractional;
                    break;
                }
                case "minutes": {
                    minutes += (int)result;
                    doubleSeconds += 60.0 * fractional;
                    break;
                }
                case "seconds": {
                    seconds += (long)((int)result);
                    doubleSeconds += fractional;
                    break;
                }
                case "millis": {
                    millis += result;
                    doubleSeconds += fractional / 1000.0;
                    break;
                }
                case "nanos": {
                    nanos += result;
                }
            }
        }
        return Duration.ofDays(days).plusHours(hours).plusMinutes(minutes).plusSeconds(seconds).plusMillis(millis).plusNanos(nanos).plusSeconds(Math.round(doubleSeconds)).plusNanos(Math.round((doubleSeconds - (double)Math.round(doubleSeconds)) * 1.0E9));
    }

    public static String formatPeriod(Period value) {
        if (value.isZero()) {
            return "0 days";
        }
        Object result = "";
        int years = value.getYears();
        int months = value.getMonths();
        int days = value.getDays();
        if (years != 0) {
            result = (String)result + years + " years ";
        }
        if (months != 0) {
            result = (String)result + months + " months ";
        }
        if (days != 0) {
            result = (String)result + days + " days ";
        }
        return ((String)result).trim();
    }

    public static Period parsePeriod(String string) {
        if ((string = string.trim()).startsWith("-P") || string.startsWith("P")) {
            return Period.parse(string);
        }
        int years = 0;
        int months = 0;
        int days = 0;
        HashSet<String> units = new HashSet<String>();
        Matcher matcher = PERIOD_PATTERN.matcher(string.trim().toLowerCase());
        int lastEnd = 0;
        while (!matcher.hitEnd()) {
            if (!matcher.find() || matcher.start() != lastEnd) {
                throw new IllegalArgumentException("Invalid period: " + string);
            }
            lastEnd = matcher.end();
            Object unit = matcher.group("unit");
            if (!((String)unit).endsWith("s")) {
                unit = (String)unit + "s";
            }
            if (!units.add((String)unit)) {
                throw new IllegalArgumentException("Time unit: " + (String)unit + " occurs more than once.");
            }
            int result = Integer.parseInt(matcher.group("time"));
            switch (unit) {
                case "years": {
                    years = result;
                    break;
                }
                case "months": {
                    months = result;
                    break;
                }
                case "days": {
                    days = result;
                }
            }
        }
        return Period.of(years, months, days);
    }

    public static String formatLocalDateTime(LocalDateTime value) {
        return value.format(DATE_TIME_FORMATTER);
    }

    public static LocalDateTime parseLocalDateTime(String string) {
        try {
            return LocalDateTime.parse(string, DATE_TIME_FORMATTER);
        }
        catch (DateTimeParseException e) {
            return LocalDateTime.parse(string);
        }
    }

    public static String formatInstant(Instant value) {
        String result = value.toString().replace('T', ' ');
        return result.substring(0, result.length() - 1);
    }

    public static Instant parseInstant(String string) {
        string = string.trim();
        return Instant.parse(string.replace(' ', 'T') + "Z");
    }

    public static String formatInetSocketAddress(InetSocketAddress address) {
        return address.getAddress().getHostAddress() + ":" + address.getPort();
    }

    public static InetSocketAddress parseInetSocketAddressResolving(String addressAndPort) throws MalformedDataException {
        InetSocketAddress inetSocketAddress = StringFormatUtils.parseInetSocketAddress(addressAndPort);
        if (!inetSocketAddress.isUnresolved()) {
            return inetSocketAddress;
        }
        String hostName = inetSocketAddress.getHostName();
        hostName = hostName.substring(0, hostName.lastIndexOf(58));
        try {
            InetAddress address = InetAddress.getByName(hostName);
            return new InetSocketAddress(address, inetSocketAddress.getPort());
        }
        catch (UnknownHostException e) {
            throw new MalformedDataException(e);
        }
    }

    public static InetSocketAddress parseInetSocketAddress(String addressString) throws MalformedDataException {
        int port;
        int portPos = addressString.lastIndexOf(58);
        if (portPos == -1) {
            try {
                return new InetSocketAddress(Integer.parseInt(addressString));
            }
            catch (NumberFormatException nfe) {
                throw new MalformedDataException(nfe);
            }
        }
        String addressStr = addressString.substring(0, portPos);
        String portStr = addressString.substring(portPos + 1);
        try {
            port = Integer.parseInt(portStr);
        }
        catch (NumberFormatException nfe) {
            throw new MalformedDataException(nfe);
        }
        if (port < 0 || port >= 65536) {
            throw new MalformedDataException("Invalid address. Port is not in range [0, 65536) " + addressStr);
        }
        if ("*".equals(addressStr)) {
            return new InetSocketAddress(port);
        }
        return InetSocketAddress.createUnresolved(addressString, port);
    }
}

