/*
 * Decompiled with CFR 0.152.
 */
package io.activej.common;

import io.activej.common.ApplicationSettings;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Spliterators;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class Utils {
    public static final int TO_STRING_LIMIT = ApplicationSettings.getInt(Utils.class, "toStringLimit", 10);

    public static <T> T nonNullElse(@Nullable T value1, T defaultValue) {
        return value1 != null ? value1 : defaultValue;
    }

    public static <T> T nonNullElseGet(@Nullable T value, Supplier<? extends T> defaultValue) {
        return value != null ? value : defaultValue.get();
    }

    public static String nonNullElseEmpty(@Nullable String value) {
        return Utils.nonNullElse(value, "");
    }

    public static <T> Set<T> nonNullElseEmpty(@Nullable Set<T> set) {
        return Utils.nonNullElse(set, Set.of());
    }

    public static <T> List<T> nonNullElseEmpty(@Nullable List<T> list) {
        return Utils.nonNullElse(list, List.of());
    }

    public static <K, V> Map<K, V> nonNullElseEmpty(@Nullable Map<K, V> map) {
        return Utils.nonNullElse(map, Map.of());
    }

    public static <T, E extends Throwable> T nonNullOrException(@Nullable T value, Supplier<E> exceptionSupplier) throws E {
        if (value != null) {
            return value;
        }
        throw (Throwable)exceptionSupplier.get();
    }

    @Contract(value="_, _ -> null")
    @Nullable
    public static <V> V nullify(@Nullable V value, Consumer<? super V> action) {
        if (value != null) {
            action.accept(value);
        }
        return null;
    }

    @Contract(value="_, _, _ -> null")
    @Nullable
    public static <V, A> V nullify(@Nullable V value, BiConsumer<? super V, A> action, A actionArg) {
        if (value != null) {
            action.accept(value, actionArg);
        }
        return null;
    }

    @Nullable
    public static <V> V replace(@Nullable V value, @Nullable V newValue, Consumer<? super V> action) {
        if (value != null && value != newValue) {
            action.accept(value);
        }
        return newValue;
    }

    @Nullable
    public static <V, A> V replace(@Nullable V value, @Nullable V newValue, BiConsumer<? super V, A> action, A actionArg) {
        if (value != null && value != newValue) {
            action.accept(value, actionArg);
        }
        return newValue;
    }

    public static boolean arraysEquals(byte[] array1, int pos1, int len1, byte[] array2, int pos2, int len2) {
        if (len1 != len2) {
            return false;
        }
        for (int i = 0; i < len1; ++i) {
            if (array1[pos1 + i] == array2[pos2 + i]) continue;
            return false;
        }
        return true;
    }

    public static boolean isBijection(Map<?, ?> map) {
        return new HashSet(map.values()).size() == map.size();
    }

    public static <T> Stream<T> iterate(Supplier<? extends T> supplier, Predicate<? super T> hasNext) {
        return Utils.iterate(supplier.get(), hasNext, $ -> supplier.get());
    }

    public static <T> Stream<T> iterate(final T seed, final Predicate<? super T> hasNext, final UnaryOperator<T> f) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(new Iterator<T>(){
            T item;
            {
                this.item = seed;
            }

            @Override
            public boolean hasNext() {
                return hasNext.test(this.item);
            }

            @Override
            public T next() {
                Object next = this.item;
                this.item = f.apply(this.item);
                return next;
            }
        }, 1040), false);
    }

    public static <T> BinaryOperator<T> noMergeFunction() {
        return (v, v2) -> {
            throw new AssertionError();
        };
    }

    public static int initialCapacity(int initialSize) {
        return (initialSize + 2) / 3 * 4;
    }

    public static <T> String toString(Collection<? extends T> collection) {
        return Utils.toString(collection, TO_STRING_LIMIT);
    }

    public static <K, V> String toString(Map<? extends K, ? extends V> map) {
        return Utils.toString(map, TO_STRING_LIMIT);
    }

    public static <T> String toString(Collection<? extends T> collection, int limit) {
        return collection.stream().limit(limit).map(Object::toString).collect(Collectors.joining(",", "[", (CharSequence)(collection.size() <= limit ? "]" : ", ..and " + (collection.size() - limit) + " more]")));
    }

    public static <K, V> String toString(Map<? extends K, ? extends V> map, int limit) {
        return map.entrySet().stream().limit(limit).map(element -> element.getKey() + "=" + element.getValue()).collect(Collectors.joining(",", "{", (CharSequence)(map.size() <= limit ? "}" : ", ..and " + (map.size() - limit) + " more}")));
    }
}

